# pyautorun
cross-platform autostart installer(s)
## usage
### try all available installers for a certain os

```python
from autorun import install_linux, InstallerConfiguration

# install
install_successful, used_installer = install_linux(InstallerConfiguration("/home/user/", "myapp"))

# uninstall
if install_successful:
    used_installer.uninstall()
```
### only use a specific installer

```python
from autorun.Windows import HKCUInstaller, InstallerConfiguration

# install
installer = HKCUInstaller(InstallerConfiguration("C:\\", "myapp"))
installer.install()

# uninstall
installer.uninstall()
```
