from assemblyline import odm


@odm.model(index=True, store=False)
class Certificate(odm.Model):
    @odm.model(index=True, store=False)
    class RSA_Info(odm.Model):
        d_param = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        e_param = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        n_param = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        p_param = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        q_param = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

    version = odm.Optional(odm.Integer())
    subject = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    issuer = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    serial_number = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    key_size = odm.Optional(odm.Integer())
    key_type = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    key_usage = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
    certificate_policies = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
    ext_key_usage = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
    valid_from = odm.Optional(odm.Date())
    valid_to = odm.Optional(odm.Date())
    signature = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    signature_algorithm = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    is_trusted = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    raw_hex = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    rsa_info = odm.Optional(odm.Compound(RSA_Info))


@odm.model(index=True, store=False)
class PE(odm.Model):
    @odm.model(index=True, store=False)
    class Header(odm.Model):
        characteristics_hash = odm.Optional(odm.Integer())
        characteristics_list = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
        machine = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        numberof_sections = odm.Optional(odm.Integer())
        numberof_symbols = odm.Optional(odm.Integer())
        signature = odm.Optional(odm.List(odm.Integer()))
        timestamp = odm.Optional(odm.Integer())
        hr_timestamp = odm.Optional(odm.Date())

    @odm.model(index=True, store=False)
    class Optional_Header(odm.Model):
        addressof_entrypoint = odm.Optional(odm.Integer())
        baseof_code = odm.Optional(odm.Integer())
        baseof_data = odm.Optional(odm.Integer())
        checksum = odm.Optional(odm.Integer())
        computed_checksum = odm.Optional(odm.Integer())
        dll_characteristics = odm.Optional(odm.Integer())
        dll_characteristics_lists = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
        file_alignment = odm.Optional(odm.Integer())
        imagebase = odm.Optional(odm.Integer())
        loader_flags = odm.Optional(odm.Integer())
        magic = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        major_image_version = odm.Optional(odm.Integer())
        major_linker_version = odm.Optional(odm.Integer())
        major_operating_system_version = odm.Optional(odm.Integer())
        major_subsystem_version = odm.Optional(odm.Integer())
        minor_image_version = odm.Optional(odm.Integer())
        minor_linker_version = odm.Optional(odm.Integer())
        minor_operating_system_version = odm.Optional(odm.Integer())
        minor_subsystem_version = odm.Optional(odm.Integer())
        numberof_rva_and_size = odm.Optional(odm.Integer())
        section_alignment = odm.Optional(odm.Integer())
        sizeof_code = odm.Optional(odm.Integer())
        sizeof_headers = odm.Optional(odm.Integer())
        sizeof_heap_commit = odm.Optional(odm.Integer())
        sizeof_heap_reserve = odm.Optional(odm.Integer())
        sizeof_image = odm.Optional(odm.Integer())
        sizeof_initialized_data = odm.Optional(odm.Integer())
        sizeof_stack_commit = odm.Optional(odm.Integer())
        sizeof_stack_reserve = odm.Optional(odm.Integer())
        sizeof_uninitialized_data = odm.Optional(odm.Integer())
        subsystem = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        win32_version_value = odm.Optional(odm.Integer())

    @odm.model(index=True, store=False)
    class Dos_Header(odm.Model):
        addressof_new_exeheader = odm.Optional(odm.Integer())
        addressof_relocation_table = odm.Optional(odm.Integer())
        checksum = odm.Optional(odm.Integer())
        file_size_in_pages = odm.Optional(odm.Integer())
        header_size_in_paragraphs = odm.Optional(odm.Integer())
        initial_ip = odm.Optional(odm.Integer())
        initial_relative_cs = odm.Optional(odm.Integer())
        initial_relative_ss = odm.Optional(odm.Integer())
        initial_sp = odm.Optional(odm.Integer())
        magic = odm.Optional(odm.Integer())
        maximum_extra_paragraphs = odm.Optional(odm.Integer())
        minimum_extra_paragraphs = odm.Optional(odm.Integer())
        numberof_relocation = odm.Optional(odm.Integer())
        oem_id = odm.Optional(odm.Integer())
        oem_info = odm.Optional(odm.Integer())
        overlay_number = odm.Optional(odm.Integer())
        used_bytes_in_the_last_page = odm.Optional(odm.Integer())

    @odm.model(index=True, store=False)
    class Rich_Header(odm.Model):
        @odm.model(index=True, store=False)
        class Entry(odm.Model):
            build_id = odm.Optional(odm.Integer())
            count = odm.Optional(odm.Integer())
            entry_id = odm.Optional(odm.Integer())

        key = odm.Optional(odm.Integer())
        hash = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        entries = odm.Optional(odm.List(odm.Compound(Entry)))

    @odm.model(index=True, store=False)
    class Authentihash(odm.Model):
        sha512 = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        sha384 = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        sha256 = odm.Optional(odm.SHA256())
        sha1 = odm.Optional(odm.SHA1())
        md5 = odm.Optional(odm.MD5())

    @odm.model(index=True, store=False)
    class TLS(odm.Model):
        section = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

    @odm.model(index=True, store=False)
    class Sections(odm.Model):
        name = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        characteristics_hash = odm.Optional(odm.Integer())
        characteristics_list = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
        entropy = odm.Optional(odm.Float())
        entropy_without_padding = odm.Optional(odm.Float())
        md5 = odm.Optional(odm.MD5())
        offset = odm.Optional(odm.Integer())
        size = odm.Optional(odm.Integer())
        sizeof_raw_data = odm.Optional(odm.Integer())
        virtual_address = odm.Optional(odm.Integer())
        virtual_size = odm.Optional(odm.Integer())
        virtual_address = odm.Optional(odm.Integer())
        fullname = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

    @odm.model(index=True, store=False)
    class Debug(odm.Model):
        @odm.model(index=True, store=False)
        class CodeView(odm.Model):
            age = odm.Optional(odm.Integer())
            cv_signature = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            filename = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            guid = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

        @odm.model(index=True, store=False)
        class POGO(odm.Model):
            @odm.model(index=True, store=False)
            class Entry(odm.Model):
                name = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                size = odm.Optional(odm.Integer())
                start_rva = odm.Optional(odm.Integer())

            entries = odm.Optional(odm.List(odm.Compound(Entry)))
            signature = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

        addressof_rawdata = odm.Optional(odm.Integer())
        characteristics = odm.Optional(odm.Integer())
        major_version = odm.Optional(odm.Integer())
        minor_version = odm.Optional(odm.Integer())
        pointerto_rawdata = odm.Optional(odm.Integer())
        sizeof_data = odm.Optional(odm.Integer())
        timestamp = odm.Optional(odm.Integer())
        hr_timestamp = odm.Optional(odm.Date())
        type = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        code_view = odm.Optional(odm.Compound(CodeView))
        pogo = odm.Optional(odm.Compound(POGO))

    @odm.model(index=True, store=False)
    class Export(odm.Model):
        @odm.model(index=True, store=False)
        class Entry(odm.Model):
            @odm.model(index=True, store=False)
            class Forward_Information(odm.Model):
                function = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                library = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

            address = odm.Optional(odm.Integer())
            forward_information = odm.Optional(odm.Compound(Forward_Information))
            function_rva = odm.Optional(odm.Integer())
            is_extern = odm.Optional(odm.Boolean())
            name = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            ordinal = odm.Optional(odm.Integer())

        entries = odm.Optional(odm.List(odm.Compound(Entry)))
        export_flags = odm.Optional(odm.Integer())
        major_version = odm.Optional(odm.Integer())
        minor_version = odm.Optional(odm.Integer())
        name = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        ordinal_base = odm.Optional(odm.Integer())
        timestamp = odm.Optional(odm.Integer())
        hr_timestamp = odm.Optional(odm.Date())

    @odm.model(index=True, store=False)
    class Import(odm.Model):
        library = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        data = odm.Optional(odm.Integer())
        hint = odm.Optional(odm.Integer())
        iat_address = odm.Optional(odm.Integer())
        iat_value = odm.Optional(odm.Integer())
        is_ordinal = odm.Optional(odm.Boolean())
        name = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        ordinal = odm.Optional(odm.Integer())

    @odm.model(index=True, store=False)
    class Load_Configuration(odm.Model):
        @odm.model(index=True, store=False)
        class Code_Integrity(odm.Model):
            catalog = odm.Optional(odm.Integer())
            catalog_offset = odm.Optional(odm.Integer())
            flags = odm.Optional(odm.Integer())
            reserved = odm.Optional(odm.Integer())

        characteristics = odm.Optional(odm.Integer())
        critical_section_default_timeout = odm.Optional(odm.Integer())
        csd_version = odm.Optional(odm.Integer())
        decommit_free_block_threshold = odm.Optional(odm.Integer())
        decommit_total_free_threshold = odm.Optional(odm.Integer())
        editlist = odm.Optional(odm.Integer())
        global_flags_clear = odm.Optional(odm.Integer())
        global_flags_set = odm.Optional(odm.Integer())
        lock_prefix_table = odm.Optional(odm.Integer())
        major_version = odm.Optional(odm.Integer())
        maximum_allocation_size = odm.Optional(odm.Integer())
        minor_version = odm.Optional(odm.Integer())
        process_affinity_mask = odm.Optional(odm.Integer())
        process_heap_flags = odm.Optional(odm.Integer())
        reserved1 = odm.Optional(odm.Integer())
        security_cookie = odm.Optional(odm.Integer())
        timedatestamp = odm.Optional(odm.Integer())
        hr_timedatestamp = odm.Optional(odm.Date())
        version = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        virtual_memory_threshold = odm.Optional(odm.Integer())
        se_handler_count = odm.Optional(odm.Integer())
        se_handler_table = odm.Optional(odm.Integer())
        guard_cf_check_function_pointer = odm.Optional(odm.Integer())
        guard_cf_dispatch_function_pointer = odm.Optional(odm.Integer())
        guard_cf_flags_list = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
        guard_cf_function_count = odm.Optional(odm.Integer())
        guard_cf_function_table = odm.Optional(odm.Integer())
        guard_flags = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        code_integrity = odm.Optional(odm.Compound(Code_Integrity))
        guard_address_taken_iat_entry_count = odm.Optional(odm.Integer())
        guard_address_taken_iat_entry_table = odm.Optional(odm.Integer())
        guard_long_jump_target_count = odm.Optional(odm.Integer())
        guard_long_jump_target_table = odm.Optional(odm.Integer())
        dynamic_value_reloc_table = odm.Optional(odm.Integer())
        hybrid_metadata_pointer = odm.Optional(odm.Integer())
        dynamic_value_reloctable_offset = odm.Optional(odm.Integer())
        dynamic_value_reloctable_section = odm.Optional(odm.Integer())
        guard_rf_failure_routine = odm.Optional(odm.Integer())
        guard_rf_failure_routine_function_pointer = odm.Optional(odm.Integer())
        reserved2 = odm.Optional(odm.Integer())
        guard_rf_verify_stackpointer_function_pointer = odm.Optional(odm.Integer())
        hotpatch_table_offset = odm.Optional(odm.Integer())
        addressof_unicode_string = odm.Optional(odm.Integer())
        reserved3 = odm.Optional(odm.Integer())

    @odm.model(index=True, store=False)
    class Resources_Manager(odm.Model):
        @odm.model(index=True, store=False)
        class Accelerator(odm.Model):
            accelerator_id = odm.Optional(odm.Integer())
            padding = odm.Optional(odm.Integer())
            ansi = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            flags = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

        @odm.model(index=True, store=False)
        class Dialog(odm.Model):
            @odm.model(index=True, store=False)
            class Item(odm.Model):
                cx = odm.Optional(odm.Integer())
                cy = odm.Optional(odm.Integer())
                extended_style = odm.Optional(odm.Integer())
                help_id = odm.Optional(odm.Integer())
                item_id = odm.Optional(odm.Integer())
                is_extended = odm.Optional(odm.Boolean())
                style = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                title = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                x = odm.Optional(odm.Integer())
                y = odm.Optional(odm.Integer())

            charset = odm.Optional(odm.Integer())
            cx = odm.Optional(odm.Integer())
            cy = odm.Optional(odm.Integer())
            dialogbox_style_list = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
            extended_style = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            extended_style_list = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
            help_id = odm.Optional(odm.Integer())
            items = odm.Optional(odm.List(odm.Compound(Item)))
            lang = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            point_size = odm.Optional(odm.Integer())
            signature = odm.Optional(odm.Integer())
            style = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            style_list = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
            sub_lang = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            title = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            typeface = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            version = odm.Optional(odm.Integer())
            weight = odm.Optional(odm.Integer())
            x = odm.Optional(odm.Integer())
            y = odm.Optional(odm.Integer())

        @odm.model(index=True, store=False)
        class Icon(odm.Model):
            icon_id = odm.Optional(odm.Integer())
            planes = odm.Optional(odm.Integer())
            height = odm.Optional(odm.Integer())
            width = odm.Optional(odm.Integer())
            lang = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            sublang = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

        @odm.model(index=True, store=False)
        class Version(odm.Model):
            @odm.model(index=True, store=False)
            class Fixed_File_Info(odm.Model):
                file_date_ls = odm.Optional(odm.Integer())
                file_date_ms = odm.Optional(odm.Integer())
                file_flags = odm.Optional(odm.Integer())
                file_flags_mask = odm.Optional(odm.Integer())
                file_os = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                file_subtype = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                file_type = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                file_version_ls = odm.Optional(odm.Integer())
                file_version_ms = odm.Optional(odm.Integer())
                product_version_ls = odm.Optional(odm.Integer())
                product_version_ms = odm.Optional(odm.Integer())
                signature = odm.Optional(odm.Integer())
                struct_version = odm.Optional(odm.Integer())

            @odm.model(index=True, store=False)
            class String_File_Info(odm.Model):
                @odm.model(index=True, store=False)
                class LangCode_Item(odm.Model):
                    @odm.model(index=True, store=False)
                    class Item(odm.Model):
                        key = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                        value = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

                    key = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                    type = odm.Optional(odm.Integer())
                    lang = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                    sublang = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                    code_page = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                    items = odm.Optional(odm.List(odm.Compound(Item)))

                key = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                type = odm.Optional(odm.Integer())
                langcode_items = odm.Optional(odm.List(odm.Compound(LangCode_Item)))

            @odm.model(index=True, store=False)
            class Var_File_Info(odm.Model):
                key = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
                type = odm.Optional(odm.Integer())
                translations = odm.Optional(odm.List(odm.Integer()))

            type = odm.Optional(odm.Integer())
            fixed_file_info = odm.Optional(odm.Compound(Fixed_File_Info))
            string_file_info = odm.Optional(odm.Compound(String_File_Info))
            var_file_info = odm.Optional(odm.Compound(Var_File_Info))

        langs_available = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
        sublangs_available = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
        accelerators = odm.Optional(odm.List(odm.Compound(Accelerator)))
        dialogs = odm.Optional(odm.List(odm.Compound(Dialog)))
        html = odm.Optional(odm.Text())
        icons = odm.Optional(odm.List(odm.Compound(Icon)))
        manifest = odm.Optional(odm.Text())
        string_table = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
        version = odm.Optional(odm.Compound(Version))

    @odm.model(index=True, store=False)
    class Resource(odm.Model):
        # Since we will end up flattening the Resources and only keeping the data nodes,
        # we keep the list of parent's resource_id and the list of parent's labels (name or resource_type)
        parent_resource_ids = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        parent_labels = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))

        characteristics = odm.Optional(odm.Integer())
        num_childs = odm.Optional(odm.Integer())
        depth = odm.Optional(odm.Integer())
        name = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        resource_id = odm.Optional(odm.Integer())
        resource_type = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        is_data = odm.Optional(odm.Boolean())
        is_directory = odm.Optional(odm.Boolean())
        major_version = odm.Optional(odm.Integer())
        minor_version = odm.Optional(odm.Integer())
        numberof_id_entries = odm.Optional(odm.Integer())
        numberof_name_entries = odm.Optional(odm.Integer())
        time_date_stamp = odm.Optional(odm.Integer())
        hr_time_date_stamp = odm.Optional(odm.Date())

        code_page = odm.Optional(odm.Integer())
        sha256 = odm.Optional(odm.SHA256())
        entropy = odm.Optional(odm.Float())
        offset = odm.Optional(odm.Integer())
        reserved = odm.Optional(odm.Integer())

    @odm.model(index=True, store=False)
    class Signature(odm.Model):
        @odm.model(index=True, store=False)
        class Signer(odm.Model):
            version = odm.Optional(odm.Integer())
            issuer = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            serial_number = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            encryption_algorithm = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            digest_algorithm = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            encrypted_digest = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            cert = odm.Optional(odm.Compound(Certificate))
            authenticated_attributes = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))
            unauthenticated_attributes = odm.Optional(odm.List(odm.EmptyableKeyword(copyto="__text__")))

        @odm.model(index=True, store=False)
        class Content_Info(odm.Model):
            algorithm = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            digest = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
            content_type = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

        version = odm.Optional(odm.Integer())
        algorithm = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
        signers = odm.Optional(odm.List(odm.Compound(Signer)))
        certificates = odm.Optional(odm.List(odm.Compound(Certificate)))
        content_info = odm.Optional(odm.Compound(Content_Info))
        check = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

    @odm.model(index=True, store=False)
    class Overlay(odm.Model):
        size = odm.Optional(odm.Integer())
        entropy = odm.Optional(odm.Float())

    @odm.model(index=True, store=False)
    class Relocation(odm.Model):
        @odm.model(index=True, store=False)
        class Entry(odm.Model):
            address = odm.Optional(odm.Integer())
            data = odm.Optional(odm.Integer())
            position = odm.Optional(odm.Integer())
            size = odm.Optional(odm.Integer())
            type = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))

        virtual_address = odm.Optional(odm.Integer())
        entries = odm.Optional(odm.List(odm.Compound(Entry)))

    name = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    format = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    imphash = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    entrypoint = odm.Optional(odm.Integer())
    header = odm.Optional(odm.Compound(Header))
    optional_header = odm.Optional(odm.Compound(Optional_Header))
    dos_header = odm.Optional(odm.Compound(Dos_Header))
    rich_header = odm.Optional(odm.Compound(Rich_Header))
    nx = odm.Optional(odm.Boolean())
    authentihash = odm.Optional(odm.Compound(Authentihash))
    tls = odm.Optional(odm.Compound(TLS))
    position_independent = odm.Optional(odm.Boolean())
    is_reproducible_build = odm.Optional(odm.Boolean())
    size_of_headers = odm.Optional(odm.Integer())
    virtual_size = odm.Optional(odm.Integer())
    size = odm.Optional(odm.Integer())
    sections = odm.Optional(odm.List(odm.Compound(Sections)))
    debugs = odm.Optional(odm.List(odm.Compound(Debug)))
    export = odm.Optional(odm.Compound(Export))
    imports = odm.Optional(odm.List(odm.Compound(Import)))
    load_configuration = odm.Optional(odm.Compound(Load_Configuration))
    resources_manager = odm.Optional(odm.Compound(Resources_Manager))
    resources = odm.Optional(odm.List(odm.Compound(Resource)))
    verify_signature = odm.Optional(odm.EmptyableKeyword(copyto="__text__"))
    signatures = odm.Optional(odm.List(odm.Compound(Signature)))
    overlay = odm.Optional(odm.Compound(Overlay))
    relocations = odm.Optional(odm.List(odm.Compound(Relocation)))
