# -*- coding: utf-8 -*-

sd_doc_data = """
####################################################################################################
# ДОКУМЕНТАЦИЯ ПО ФОРМАТУ .sd, ПРЕДНАЗНАЧЕННОМУ ДЛЯ ХРАНЕНИЯ СЛУЖЕБНЫХ И КОНФИГУРАЦИОННЫХ ДАННЫХ
####################################################################################################
#
# Основные концепции и возможности, заложенные при разработке формата:
#    Максимальная доступность для восприятия сложных по структуре данных
#    Простые и интуитивно понятные синтаксические правила
#    Возможность однострочной записи простых словарей и списков
#    Возможность многострочной записи многомерных словарей
#    Возможность многострочной записи строкового значения
#    Возможность многострочной записи длинных списков
#    Возможность работы с комментариями к данным и файлу
# --------------------------------------------------------------------------------------------------
# Правила для записи содержимого файла формата .sd:
#
#    Основное:
#    В рамках правил, удобство для восприятия данных и их структуры определяет выбор вида записи
#    После записи ключей первого уровня ставится знак равенства
#    Имена ключей записываются с использованием латинских букв, цифр и знака подчёркивания
#    Имена ключей начинаются с буквы или с нижнего подчёркивания и не содержат пробелов
#    Для однострочной записи, после знака равно рекомендуется суммарная запись не более 100 символов
#    Значения, в которых есть решётка, пробелы или запятые, необходимо заключить в тройные кавычки
#    Значения, заканчивающиеся двоеточием, необходимо заключить в тройные кавычки
#    Значения, начинающиеся с точки с запятой, необходимо заключить в тройные кавычки
#    Значения в тройных кавычках рекомендуется делать либо единственными, либо последними
#    Перед и после надстрочного комментария и многострочной записи добавляются пустые строки
#    Для многострочной записи, после или перед описаниями к файлу, добавляются двойные пустые строки
#    Для разметки файла используются следующие одиночные или тройные знаки: #.=:\"\"\";'''
#
#    Запись комментариев:
#    Текстовые комментарии и описания записываются после знака решётки
#    Комментарии, записанные над строкой или в строке с ключом первого уровня, принадлежат ключам
#    Для комментария, записанного в строке с ключом, рекомендуется четырёх пробельный отступ
#    Для многострочной записи словарей ключам доступны только комментарии, записанные в строках
#
#    Запись словарей:
#    При однострочной записи словаря, перед и после знака равенства ставится пробел
#    При многострочной записи словаря, пробел ставится перед знаком равенства
#    После двоеточия и запятой необходим пробел
#    Для записи словарей с более чем одним уровнем вложенности используется многострочная запись
#    Для многострочной записи значение вложенного словаря записывается в строке под ключом
#    При многострочной записи словарей, перед именами ключей необходимы точки с одним пробелом после
#    Количество точек перед именами вложенных ключей определяется глубиной их вложенности
#    Значения для ключа без вложенного словаря записываются на одной строке с ключом
#    При однострочной записи словаря, для каждого ключа возможна запись одного строкового значения
#    Рекомендуемое количество знаков всех элементов списка для каждого ключа составляет 100 знаков
#
#    Запись списков:
#    При однострочной записи элементов списка между их значениями необходима запятая
#    Словари не могут быть элементами списка. Переданные словари будут приведены к строковому виду
#    Рекомендуемая длина каждого значения списка не должна превышать 50 символов
#    Значения, превышающие 50 символов, оптимально должны быть последними
#    Для списков длинной более 100 знаков, нужно использовать многострочную запись
#    Для списков имеющих вложенный список, нужно использовать многострочную запись
#    При многострочной записи списков, запятая после каждого значения не ставится
#
#    Многострочная запись строкового значения:
#    Только для ключа первого уровня возможна многострочная запись единственного значения
#    Для многострочной записи одного значения необходимы обрамляющие строки с тройными кавычками
#    Обрамляющие строки с тройными кавычками находятся соответственно над и под значением
#
####################################################################################################


# Пример записи данных в формате .sd (An example of writing data in the .sd format):
main_key_0 =    # multiline list entry
; large_lists_of_values_are_written_into_a_column
; lists_containing_nested_lists_are_written_to_a_multi_line_format
; lists_written_with_more_than_a_hundred_characters_should_be_written_in_a_multi_line_format
;; value_0_4_1
;; value_0_4_2
;;; value_0_4_3_1
;;; value_0_4_3_2
;; value_0_4_4
; value_0_5


# some comment for main_key_1
main_key_1 =    # multi-line dictionary entry
. key_1_1:
.. key_1_1_1:  '''String with spaces. Possibly other type of quotes.'''
.. key_1_1_2:
... key_1_1_2_1: value_without_spaces    # some comment for key_1_1_2_1
... key_1_1_2_2:  '''triple quoted values can contain characters such as space or comma'''
... key_1_1_2_3: Values_ending_with_a_':'_or_starting_with_a_';'_should_be_enclosed_in_triple_quotes
. key_1_2: value_1_2_1, '''last list element'''
. key_1_3: a_good_solution_is_to_place_an_element_value_greater_than_50_characters_as_the_only_one


main_key_2 = some_value_will_be_read_as_a_string    # comment for the main_key_2
main_key_3 = value_3_1, value_3_2, the_long_element_value_over_50_characters_is_placed_last
main_key_4 = key_4_1: v_4_1_1, key_4_2: in_a_one_line_notation_each_key_has_only_one_str_value
main_key_5 = key_5_1: v_5_1_1, key_5_2: v_5_2_1, key_5_3: '''should be used no more than 3 pair'''


# comment for the main_key_6
main_key_6 =    # multiline str entry
\"\"\"
Multi-line write of value,
for main_key_6.
\"\"\"


_main_key_7 = '''I'm glad to your attention. If bugs are found, write: bug_report@daliton.org'''


####################################################################################################
#
#    Для декодирования данных хранящихся в формате .sd необходимо передать адрес файла с данными:
#    from sd_format import sd
#    sd_obj = sd(sd_file_path)
#    my_dict = sd_obj.decoding_result
#
# После декодирования данные преобразуются в Python dict:
#     dict = {
#       'keys_comments': {
#           'own_comments':
#               ['File title',
#                'Top description of configuration file',
#                'Bottom part of the descriptions and comments for the configuration file'],
#           'main_key_0': {
#               'own_comments':
#                   ['Пример записи данных в формате .sd (An example of writing data in the .sd format):\n',
#                    'multiline list entry']
#           },
#           'main_key_1': {
#               'key_1_1': {
#                   'own_comments': ['', ''],
#                   'key_1_1_1': {'own_comments': ['', '']},
#                   'key_1_1_2': {
#                       'own_comments': ['', ''],
#                       'key_1_1_2_1': {'own_comments': ['', 'some comment for key_1_1_2_1']},
#                       'key_1_1_2_2': {'own_comments': ['', '']},
#                       'key_1_1_2_3': {'own_comments': ['', '']}
#                   }
#               },
#               'key_1_2': {'own_comments': ['', '']},
#               'key_1_3': {'own_comments': ['', '']},
#               'own_comments': ['some comment for main_key_1', 'multi-line dictionary entry']
#           },
#           'main_key_2': {'own_comments': ['', 'comment for the main_key_2']},
#           'main_key_3': {'own_comments': ['', '']},
#           'main_key_4': {'own_comments': ['', '']},
#           'main_key_5': {'own_comments': ['', '']},
#           'main_key_6': {'own_comments': ['comment for the main_key_6', 'multiline str entry']},
#           '_main_key_7': {'own_comments': ['', '']}},
#       'main_key_0':
#           ['large_lists_of_values_are_written_into_a_column',
#            'lists_containing_nested_lists_are_written_to_a_multi_line_format',
#            'lists_written_with_more_than_a_hundred_characters_should_be_written_in_a_multi_line_format',
#            ['value_0_4_1', 'value_0_4_2', ['value_0_4_3_1', 'value_0_4_3_2'], 'value_0_4_4'],
#            'value_0_5'],
#       'main_key_1': {
#           'key_1_1': {'key_1_1_1': 'String with spaces. Possibly other type of quotes.',
#                       'key_1_1_2': {
#                           'key_1_1_2_1': 'value_without_spaces',
#                           'key_1_1_2_2': 'triple quoted values can contain characters such as space or comma',
#                           'key_1_1_2_3': "Values_ending_with_a_':'_or_starting_with_a_';'_should_be_enclosed_in_triple_quotes"}
#                       },
#           'key_1_2': ['value_1_2_1', 'last list element'],
#           'key_1_3': 'a_good_solution_is_to_place_an_element_value_greater_than_50_characters_as_the_only_one'
#       },
#       'main_key_2': 'some_value_will_be_read_as_a_string',
#       'main_key_3': ['value_3_1', 'value_3_2', 'the_long_element_value_over_50_characters_is_placed_last'],
#       'main_key_4': {'key_4_1': 'v_4_1_1', 'key_4_2': 'in_a_one_line_notation_each_key_has_only_one_str_value'},
#       'main_key_5': {'key_5_1': 'v_5_1_1', 'key_5_2': 'v_5_2_1', 'key_5_3': 'should be used no more than 3 pair'},
#       'main_key_6': 'Multi-line write of value,\\nfor main_key_6.',
#       '_main_key_7': "I'm glad to your attention. If bugs are found, write: bug_report@daliton.org"
#
# Если Python словарь нужно сохранить в файл в формате .sd, в качестве параметров необходимо
# передать адрес по которому нужно сохранить файл, а также сам словарь:
#    from sd_format import sd
#    sd(sd_file_path, my_dict)
#
####################################################################################################
"""


def documentation_output_about_sd_format():
    print()
    print(sd_doc_data)
    print()
    return sd_doc_data


sd_documentation_output = documentation_output_about_sd_format
sd_info = documentation_output_about_sd_format
