from django.utils.text import slugify


class ColdCMSPageMixin:
    def full_clean(self, *args, **kwargs):
        super().full_clean(*args, **kwargs)
        base_slug = slugify(self.title, allow_unicode=False)
        if base_slug:
            self.slug = self._get_autogenerated_slug(base_slug)
