# Generated by Django 3.1.7 on 2021-04-13 08:00

import json
from django.core.serializers.json import DjangoJSONEncoder
from django.db import migrations
import wagtail.core.blocks
import wagtail.core.fields


MENUOPTION_DATA = []


class Migration(migrations.Migration):

    dependencies = [
        ('site_settings', '0010_auto_20210402_1337'),
    ]

    def dump_data_menu_options(apps, schema_editor):
        MenuOptions = apps.get_model('site_settings', 'MenuOptions')
        menuoption = MenuOptions.objects.first()
        if menuoption:
            for content_data in menuoption.icons.stream_data:
                content_data.pop("id")
                MENUOPTION_DATA.append(content_data)

    def load_data_menu_options(apps, schema_editor):
        MenuOptions = apps.get_model('site_settings', 'MenuOptions')

        if MENUOPTION_DATA:
            menuoption = MenuOptions.objects.first()
            stream_block = menuoption.custom_menu_items.stream_block
            raw_text = json.dumps(MENUOPTION_DATA, cls=DjangoJSONEncoder)
            menuoption.custom_menu_items = wagtail.core.blocks.StreamValue(
                stream_block, [], is_lazy=True, raw_text=raw_text
            )
            menuoption.save()

    operations = [
        migrations.RunPython(
            dump_data_menu_options, migrations.RunPython.noop
        ),
        migrations.RemoveField(
            model_name='menuoptions',
            name='icons',
        ),
        migrations.AddField(
            model_name='menuoptions',
            name='custom_menu_items',
            field=wagtail.core.fields.StreamField([('social_media_icon', wagtail.core.blocks.StructBlock([('icon_type', wagtail.core.blocks.ChoiceBlock(blank=False, choices=[('facebook', 'Facebook'), ('twitter', 'Twitter'), ('github', 'GitHub'), ('gitlab', 'GitLab'), ('linkedin', 'LinkedIn'), ('instagram', 'Instagram'), ('youtube', 'YouTube'), ('pinterest', 'Pinterest'), ('tumblr', 'Tumblr')], help_text='Which social media is the URL linking to (will display the corresponding icon)', icon='site', label='Icon type')), ('link', wagtail.core.blocks.URLBlock(help_text='URL to your social media', icon='link', label='Link')), ('link_text', wagtail.core.blocks.CharBlock(help_text='The text displayed next to the social media icon. Should be of the type "Follow us on ...". Be aware that some social media companies require that this text appears next to their logo. Make sure by checking their branding website.', label='Link text', max_length=40, required=False))])), ('link', wagtail.core.blocks.StructBlock([('link', wagtail.core.blocks.URLBlock(help_text='URL', icon='link', label='Link')), ('link_text', wagtail.core.blocks.CharBlock(label='Link text', max_length=40, required=False))]))], blank=True, null=True, verbose_name='Links and social media icons'),
        ),
        migrations.RunPython(
            load_data_menu_options, migrations.RunPython.noop
        ),
    ]
