# Generated by Django 3.1.7 on 2021-04-02 14:33

import json
from django.core.serializers.json import DjangoJSONEncoder
import coldcms.blocks.blocks
from django.db import migrations
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.documents.blocks
import wagtail.images.blocks


PAGES_DATA = {}

def update_values(values):
    for value in values:
        value["value"]["logo"] = {
            "image_type": "image",
            "img": value["value"]["logo"],
            "svg": None,
            "alt": "",
        }
    return values


class Migration(migrations.Migration):

    dependencies = [
        ('partners', '0004_auto_20210216_1419'),
    ]

    def dump_data_with_image_update(apps, schema_editor):
        global PAGES_DATA
        PartnersPage = apps.get_model('partners', 'PartnersPage')
        for page in PartnersPage.objects.all():
            page_value = []
            for content_data in page.partners_groups.stream_data:
                content_data.pop("id")

                if content_data["type"] == "partners_groups":
                    value = {
                        "category_name": content_data["value"]["category_name"],
                        "partners": update_values(content_data["value"]["partners"]),
                    }
                    content_data["value"] = value

                page_value.append(content_data)
            PAGES_DATA[page.pk] = page_value


    def load_data_with_image_update(apps, schema_editor):
        global PAGES_DATA
        PartnersPage = apps.get_model('partners', 'PartnersPage')
        for pk, content_block in PAGES_DATA.items():
            page = PartnersPage.objects.get(pk=pk)
            stream_block = page.partners_groups.stream_block
            raw_text = json.dumps(content_block, cls=DjangoJSONEncoder)
            page.partners_groups = wagtail.core.blocks.StreamValue(
                stream_block, [], is_lazy=True, raw_text=raw_text
            )
            page.save()


    operations = [
        migrations.RunPython(
            dump_data_with_image_update, migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='partnerspage',
            name='partners_groups',
            field=wagtail.core.fields.StreamField([('partners_groups', wagtail.core.blocks.StructBlock([('category_name', wagtail.core.blocks.CharBlock(help_text='The category of partner (ex: Institution)', label='Category name', max_length=100, required=False)), ('partners', wagtail.core.blocks.StreamBlock([('partners', wagtail.core.blocks.StructBlock([('name', wagtail.core.blocks.CharBlock(label='Name', max_length=100, required=False)), ('logo', wagtail.core.blocks.StructBlock([('image_type', wagtail.core.blocks.ChoiceBlock(choices=[('image', 'JPG, PNG, WEBP, GIF'), ('svg', 'SVG')], classname='coldcms-admin__choice-handler coldcms-admin__choice-handler--image_type', label='Image type')), ('img', wagtail.images.blocks.ImageChooserBlock(form_classname='coldcms-admin__choice-handler-target--image_type coldcms-admin__choice-handler-hidden-if--svg', label='Image', required=False)), ('svg', wagtail.documents.blocks.DocumentChooserBlock(form_classname='coldcms-admin__choice-handler-target--image_type coldcms-admin__choice-handler-hidden-if--image', label='Svg', required=False, validators=[coldcms.blocks.blocks.svg_only])), ('alt', wagtail.core.blocks.CharBlock(default='', form_classname='coldcms-admin__choice-handler-target--image_type coldcms-admin__choice-handler-hidden-if--image', label='Svg description', max_length=200, required=False))], required=False)), ('website_url', wagtail.core.blocks.CharBlock(label="Partner's Website", required=False))]))], label='Partners'))]))], blank=True, null=True, verbose_name="Partners' groups"),
        ),
        migrations.RunPython(
            load_data_with_image_update, migrations.RunPython.noop
        ),
    ]
