# Generated by Django 3.1.7 on 2021-08-05 17:30

from django.apps import apps as django_apps
from django.db import migrations
from django.utils.text import slugify
from coldcms.blog.models import (
    BlogTagGroupByBlogPage,
    BlogTagIndexPage,
    BlogListTagsIndexPage,
    BlogListAuthorsIndexPage,
    BlogListDatesIndexPage,
)
from coldcms.wagtail_customization.apps import WagtailCustomizationConfig
from django.utils.translation import ugettext_lazy as _


def change_parent_to_blog_objects_index_page(pages):
    for page in pages:
        home = page.get_first_root_node().get_first_child()
        if page.get_parent() == home and hasattr(home, 'genericpage'):
            page.move(home.genericpage, 'last-child')


def create_tags_groupby_blog_page():
    for page in BlogTagIndexPage.objects.all():
        blogs = set(
            page_tag.content_object.get_parent()
            for page_tag in page.tag.blog_blogpagetag_items.all()
        )

        for blog in blogs:
            tag_groupby_blog_page = BlogTagGroupByBlogPage.objects.filter(
                tag=page.tag
            ).child_of(blog)

            if not tag_groupby_blog_page:
                blog_tag_groupby_blog_page = BlogTagGroupByBlogPage(
                    tag=page.tag,
                    title=_(f"Tag {page.tag.name} group by blog {blog.title}"),
                    slug=slugify(page.tag.name),
                )
                blog.add_child(instance=blog_tag_groupby_blog_page)
                blog_tag_groupby_blog_page.save_revision().publish()


def migrate_blog_system(apps, schema_editor):
    # Disabled signals to build page
    app_config = django_apps.get_app_config(WagtailCustomizationConfig.label)
    app_config.disable_signals()

    change_parent_to_blog_objects_index_page(BlogListTagsIndexPage.objects.all())
    change_parent_to_blog_objects_index_page(BlogListAuthorsIndexPage.objects.all())
    change_parent_to_blog_objects_index_page(BlogListDatesIndexPage.objects.all())

    create_tags_groupby_blog_page()

    # Enabled signals to build pages
    app_config.ready()


class Migration(migrations.Migration):

    dependencies = [
        ('blog', '0004_blogtaggroupbyblogpage'),
    ]

    operations = [
        migrations.RunPython(
            migrate_blog_system, migrations.RunPython.noop
        ),
    ]
