"""
=====================
Extending Flytekit
=====================

.. currentmodule:: flytekit.extend

This package contains things that are useful when extending Flytekit.

.. autosummary::
   :toctree: generated/

   get_serializable
   context_manager
   SQLTask
   IgnoreOutputs
   PythonTask
   ExecutionState
   Image
   ImageConfig
   SerializationSettings
   Interface
   Promise
   TaskPlugins
   DictTransformer
   T
   TypeEngine
   TypeTransformer
   PythonCustomizedContainerTask
   ExecutableTemplateShimTask
   ShimTaskExecutor
   DataPersistence
   DataPersistencePlugins
"""

from flytekit.common.translator import get_serializable
from flytekit.core import context_manager
from flytekit.core.base_sql_task import SQLTask
from flytekit.core.base_task import IgnoreOutputs, PythonTask, TaskResolverMixin
from flytekit.core.class_based_resolver import ClassStorageTaskResolver
from flytekit.core.context_manager import ExecutionState, Image, ImageConfig, SerializationSettings
from flytekit.core.data_persistence import DataPersistence, DataPersistencePlugins
from flytekit.core.interface import Interface
from flytekit.core.promise import Promise
from flytekit.core.python_customized_container_task import PythonCustomizedContainerTask
from flytekit.core.shim_task import ExecutableTemplateShimTask, ShimTaskExecutor
from flytekit.core.task import TaskPlugins
from flytekit.core.type_engine import DictTransformer, T, TypeEngine, TypeTransformer
