"""

    iceaddr: Look up information about Icelandic streets, addresses, 
             placenames, landmarks, locations and postcodes.

    Copyright (c) 2018-2020 Sveinbjorn Thordarson.

    This file contains code and data related to Icelandic postcodes.

"""

POSTCODES = {
    101: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Miðborg",
    },
    102: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "",
    },
    103: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Háaleitis- og Bústaðahverfi",
    },
    104: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Laugardalur",
    },
    105: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Hlíðar",
    },
    107: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Vesturbær",
    },
    108: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Háaleitis- og Bústaðahverfi",
    },
    109: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Breiðholt",
    },
    110: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Árbær",
    },
    111: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Breiðholt",
    },
    112: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Grafarvogur",
    },
    113: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Grafarholt og Úlfarsárdalur",
    },
    116: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Þéttbýli",
        "lysing": "Kjalarnes",
    },
    121: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    123: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    124: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    125: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    127: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    128: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    129: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    130: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    132: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Pósthólf",
    },
    162: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "tegund": "Dreifbýli",
    },
    170: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Seltjarnarnes",
        "stadur_tgf": "Seltjarnarnesi",
        "tegund": "Þéttbýli",
    },
    172: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Seltjarnarnes",
        "stadur_tgf": "Seltjarnarnesi",
        "tegund": "Pósthólf",
    },
    190: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Vogar",
        "stadur_tgf": "Vogum",
        "tegund": "Þéttbýli",
    },
    191: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Vogar",
        "stadur_tgf": "Vogum",
        "tegund": "Dreifbýli",
    },
    200: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "tegund": "Þéttbýli",
    },
    201: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "tegund": "Þéttbýli",
    },
    202: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "tegund": "Pósthólf",
    },
    203: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "tegund": "Þéttbýli",
    },
    206: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "tegund": "Þéttbýli",
    },
    210: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Garðabær",
        "stadur_tgf": "Garðabæ",
        "tegund": "Þéttbýli",
    },
    212: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Garðabær",
        "stadur_tgf": "Garðabæ",
        "tegund": "Pósthólf",
    },
    220: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Hafnarfjörður",
        "stadur_tgf": "Hafnarfirði",
        "tegund": "Þéttbýli",
    },
    221: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Hafnarfjörður",
        "stadur_tgf": "Hafnarfirði",
        "tegund": "Þéttbýli",
    },
    222: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Hafnarfjörður",
        "stadur_tgf": "Hafnarfirði",
        "tegund": "Pósthólf",
    },
    225: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Garðabær",
        "stadur_tgf": "Garðabær",
        "tegund": "Þéttbýli",
    },
    230: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "tegund": "Þéttbýli",
    },
    232: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "tegund": "Pósthólf",
    },
    233: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "tegund": "Dreifbýli",
    },
    235: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "tegund": "Þéttbýli",
        "lysing": "Keflavíkurflugvöllur",
    },
    240: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Grindavík",
        "stadur_tgf": "Grindavík",
        "tegund": "Þéttbýli",
    },
    241: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Grindavík",
        "stadur_tgf": "Grindavík",
        "tegund": "Dreifbýli",
    },
    245: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Sandgerði",
        "stadur_tgf": "Sandgerði",
        "tegund": "Þéttbýli",
    },
    246: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Sandgerði",
        "stadur_tgf": "Sandgerði",
        "tegund": "Dreifbýli",
    },
    250: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Garður",
        "stadur_tgf": "Garði",
        "tegund": "Þéttbýli",
    },
    251: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Garður",
        "stadur_tgf": "Garði",
        "tegund": "Dreifbýli",
    },
    260: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "tegund": "Þéttbýli",
    },
    262: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "tegund": "Þéttbýli",
        "lysing": "Ásbrú",
    },
    270: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Mosfellsbær",
        "stadur_tgf": "Mosfellsbæ",
        "tegund": "Þéttbýli",
    },
    271: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Mosfellsbær",
        "stadur_tgf": "Mosfellsbæ",
        "tegund": "Dreifbýli",
    },
    276: {
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "stadur_nf": "Mosfellsbær",
        "stadur_tgf": "Mosfellsbæ",
        "tegund": "Dreifbýli",
        "lysing": "Kjós",
    },
    300: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Akranes",
        "stadur_tgf": "Akranesi",
        "tegund": "Þéttbýli",
    },
    301: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Akranes",
        "stadur_tgf": "Akranesi",
        "tegund": "Dreifbýli",
    },
    302: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Akranes",
        "stadur_tgf": "Akranesi",
        "tegund": "Pósthólf",
    },
    310: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Borgarnes",
        "stadur_tgf": "Borgarnesi",
        "tegund": "Þéttbýli",
    },
    311: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Borgarnes",
        "stadur_tgf": "Borgarnesi",
        "tegund": "Dreifbýli",
    },
    320: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Reykholt í Borgarfirði",
        "stadur_tgf": "Reykholt í Borgarfirði",
        "tegund": "Dreifbýli",
    },
    340: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Stykkishólmur",
        "stadur_tgf": "Stykkishólmi",
        "tegund": "Þéttbýli",
    },
    341: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Stykkishólmur",
        "stadur_tgf": "Stykkishólmi",
        "tegund": "Dreifbýli",
    },
    342: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Borgarnes",
        "stadur_tgf": "Borgarnesi",
        "tegund": "Þéttbýli",
    },
    345: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Flatey á Breiðafirði",
        "stadur_tgf": "Flatey á Breiðafirði",
        "tegund": "Dreifbýli",
    },
    350: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Grundarfjörður",
        "stadur_tgf": "Grundarfirði",
        "tegund": "Þéttbýli",
    },
    351: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Grundarfjörður",
        "stadur_tgf": "Grundarfirði",
        "tegund": "Dreifbýli",
    },
    355: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Ólafsvík",
        "stadur_tgf": "Ólafsvík",
        "tegund": "Þéttbýli",
    },
    356: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Snæfellsbær",
        "stadur_tgf": "Snæfellsbæ",
        "tegund": "Dreifbýli",
    },
    360: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Hellissandur",
        "stadur_tgf": "Hellissandi",
        "tegund": "Þéttbýli",
    },
    370: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Búðardalur",
        "stadur_tgf": "Búðardal",
        "tegund": "Þéttbýli",
    },
    371: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Búðardalur",
        "stadur_tgf": "Búðardal",
        "tegund": "Dreifbýli",
    },
    380: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Reykhólahreppur",
        "stadur_tgf": "Reykhólahreppi",
        "tegund": "Þéttbýli",
    },
    381: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Reykhólahreppur",
        "stadur_tgf": "Reykhólahreppi",
        "tegund": "Dreifbýli",
    },
    400: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Ísafjörður",
        "stadur_tgf": "Ísafirði",
        "tegund": "Þéttbýli",
    },
    401: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Ísafjörður",
        "stadur_tgf": "Ísafirði",
        "tegund": "Dreifbýli",
    },
    410: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Hnífsdalur",
        "stadur_tgf": "Hnífsdal",
        "tegund": "Þéttbýli",
    },
    415: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Bolungarvík",
        "stadur_tgf": "Bolungarvík",
        "tegund": "Þéttbýli",
    },
    416: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Bolungarvík",
        "stadur_tgf": "Bolungarvík",
        "tegund": "Dreifbýli",
    },
    420: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Súðavík",
        "stadur_tgf": "Súðavík",
        "tegund": "Þéttbýli",
    },
    421: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Súðavík",
        "stadur_tgf": "Súðavík",
        "tegund": "Dreifbýli",
    },
    425: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Flateyri",
        "stadur_tgf": "Flateyri",
        "tegund": "Þéttbýli",
    },
    426: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Flateyri",
        "stadur_tgf": "Flateyri",
        "tegund": "Dreifbýli",
    },
    430: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Suðureyri",
        "stadur_tgf": "Suðureyri",
        "tegund": "Þéttbýli",
    },
    431: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Suðureyri",
        "stadur_tgf": "Suðureyri",
        "tegund": "Dreifbýli",
    },
    450: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Patreksfjörður",
        "stadur_tgf": "Patreksfirði",
        "tegund": "Þéttbýli",
    },
    451: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Patreksfjörður",
        "stadur_tgf": "Patreksfirði",
        "tegund": "Dreifbýli",
    },
    460: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Tálknafjörður",
        "stadur_tgf": "Tálknafirði",
        "tegund": "Þéttbýli",
    },
    461: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Tálknafjörður",
        "stadur_tgf": "Tálknafirði",
        "tegund": "Dreifbýli",
    },
    465: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Bíldudalur",
        "stadur_tgf": "Bíldudal",
        "tegund": "Þéttbýli",
    },
    466: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Bíldudalur",
        "stadur_tgf": "Bíldudal",
        "tegund": "Dreifbýli",
    },
    470: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Þingeyri",
        "stadur_tgf": "Þingeyri",
        "tegund": "Þéttbýli",
    },
    471: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Þingeyri",
        "stadur_tgf": "Þingeyri",
        "tegund": "Dreifbýli",
    },
    500: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Staður",
        "stadur_tgf": "Stað",
        "tegund": "Dreifbýli",
    },
    510: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Hólmavík",
        "stadur_tgf": "Hólmavík",
        "tegund": "Þéttbýli",
    },
    511: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Hólmavík",
        "stadur_tgf": "Hólmavík",
        "tegund": "Dreifbýli",
    },
    512: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Hólmavík",
        "stadur_tgf": "Hólmavík",
        "tegund": "Dreifbýli",
    },
    520: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Drangsnes",
        "stadur_tgf": "Drangsnesi",
        "tegund": "Þéttbýli",
    },
    524: {
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "stadur_nf": "Árneshreppur",
        "stadur_tgf": "Árneshreppi",
        "tegund": "Dreifbýli",
    },
    530: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Hvammstangi",
        "stadur_tgf": "Hvammstanga",
        "tegund": "Þéttbýli",
    },
    531: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Hvammstangi",
        "stadur_tgf": "Hvammstanga",
        "tegund": "Dreifbýli",
    },
    540: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Blönduós",
        "stadur_tgf": "Blönduósi",
        "tegund": "Þéttbýli",
    },
    541: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Blönduós",
        "stadur_tgf": "Blönduósi",
        "tegund": "Dreifbýli",
    },
    545: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Skagaströnd",
        "stadur_tgf": "Skagaströnd",
        "tegund": "Þéttbýli",
    },
    546: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Skagaströnd",
        "stadur_tgf": "Skagaströnd",
        "tegund": "Dreifbýli",
    },
    550: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Sauðárkrókur",
        "stadur_tgf": "Sauðárkróki",
        "tegund": "Þéttbýli",
    },
    551: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Sauðárkrókur",
        "stadur_tgf": "Sauðárkróki",
        "tegund": "Dreifbýli",
    },
    560: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Varmahlíð",
        "stadur_tgf": "Varmahlíð",
        "tegund": "Þéttbýli",
    },
    561: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Varmahlíð",
        "stadur_tgf": "Varmahlíð",
        "tegund": "Dreifbýli",
    },
    565: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Hofsós",
        "stadur_tgf": "Hofsós",
        "tegund": "Þéttbýli",
    },
    566: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Hofsós",
        "stadur_tgf": "Hofsós",
        "tegund": "Dreifbýli",
    },
    570: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Fljót",
        "stadur_tgf": "Fljótum",
        "tegund": "Dreifbýli",
    },
    580: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Siglufjörður",
        "stadur_tgf": "Siglufirði",
        "tegund": "Þéttbýli",
    },
    581: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Siglufjörður",
        "stadur_tgf": "Siglufirði",
        "tegund": "Dreifbýli",
    },
    600: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "tegund": "Þéttbýli",
    },
    601: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "tegund": "Dreifbýli",
    },
    602: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "tegund": "Pósthólf",
    },
    603: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "tegund": "Þéttbýli",
    },
    604: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "tegund": "Þéttbýli",
    },
    605: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "tegund": "Þéttbýli",
    },
    606: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "tegund": "Þéttbýli",
    },
    607: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "tegund": "Þéttbýli",
    },
    610: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Grenivík",
        "stadur_tgf": "Grenivík",
        "tegund": "Þéttbýli",
    },
    611: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Grímsey",
        "stadur_tgf": "Grímsey",
        "tegund": "Þéttbýli",
    },
    616: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Grenivík",
        "stadur_tgf": "Grenivík",
        "tegund": "Dreifbýli",
    },
    620: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Dalvík",
        "stadur_tgf": "Dalvík",
        "tegund": "Þéttbýli",
    },
    621: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Dalvík",
        "stadur_tgf": "Dalvík",
        "tegund": "Dreifbýli",
    },
    625: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Ólafsfjörður",
        "stadur_tgf": "Ólafsfirði",
        "tegund": "Þéttbýli",
    },
    626: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Ólafsfjörður",
        "stadur_tgf": "Ólafsfirði",
        "tegund": "Dreifbýli",
    },
    630: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Hrísey",
        "stadur_tgf": "Hrísey",
        "tegund": "Þéttbýli",
    },
    640: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Húsavík",
        "stadur_tgf": "Húsavík",
        "tegund": "Þéttbýli",
    },
    641: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Húsavík",
        "stadur_tgf": "Húsavík",
        "tegund": "Dreifbýli",
    },
    645: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Fosshóll",
        "stadur_tgf": "Fosshóli",
        "tegund": "Dreifbýli",
    },
    650: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Laugar",
        "stadur_tgf": "Laugum",
        "tegund": "Þéttbýli",
    },
    660: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Mývatn",
        "stadur_tgf": "Mývatni",
        "tegund": "Dreifbýli",
    },
    670: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Kópasker",
        "stadur_tgf": "Kópaskeri",
        "tegund": "Þéttbýli",
    },
    671: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Kópasker",
        "stadur_tgf": "Kópaskeri",
        "tegund": "Dreifbýli",
    },
    675: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Raufarhöfn",
        "stadur_tgf": "Raufarhöfn",
        "tegund": "Þéttbýli",
    },
    676: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Raufarhöfn",
        "stadur_tgf": "Raufarhöfn",
        "tegund": "Dreifbýli",
    },
    680: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Þórshöfn",
        "stadur_tgf": "Þórshöfn",
        "tegund": "Þéttbýli",
    },
    681: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Þórshöfn",
        "stadur_tgf": "Þórshöfn",
        "tegund": "Dreifbýli",
    },
    685: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Bakkafjörður",
        "stadur_tgf": "Bakkafirði",
        "tegund": "Þéttbýli",
    },
    686: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Bakkafjörður",
        "stadur_tgf": "Bakkafirði",
        "tegund": "Dreifbýli",
    },
    690: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Vopnafjörður",
        "stadur_tgf": "Vopnafirði",
        "tegund": "Þéttbýli",
    },
    691: {
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "stadur_nf": "Vopnafjörður",
        "stadur_tgf": "Vopnafirði",
        "tegund": "Dreifbýli",
    },
    700: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Egilsstaðir",
        "stadur_tgf": "Egilsstöðum",
        "tegund": "Þéttbýli",
    },
    701: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Egilsstaðir",
        "stadur_tgf": "Egilsstöðum",
        "tegund": "Dreifbýli",
    },
    710: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Seyðisfjörður",
        "stadur_tgf": "Seyðisfirði",
        "tegund": "Þéttbýli",
    },
    711: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Seyðisfjörður",
        "stadur_tgf": "Seyðisfirði",
        "tegund": "Dreifbýli",
    },
    715: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Mjóifjörður",
        "stadur_tgf": "Mjóafirði",
        "tegund": "Dreifbýli",
    },
    720: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Borgarfjörður eystri",
        "stadur_tgf": "Borgarfirði eystri",
        "tegund": "Dreifbýli",
    },
    721: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Borgarfjörður eystri",
        "stadur_tgf": "Borgarfirði eystri",
        "tegund": "Dreifbýli",
    },
    730: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Reyðarfjörður",
        "stadur_tgf": "Reyðarfirði",
        "tegund": "Þéttbýli",
    },
    731: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Reyðarfjörður",
        "stadur_tgf": "Reyðarfirði",
        "tegund": "Dreifbýli",
    },
    735: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Eskifjörður",
        "stadur_tgf": "Eskifirði",
        "tegund": "Þéttbýli",
    },
    736: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Eskifjörður",
        "stadur_tgf": "Eskifirði",
        "tegund": "Dreifbýli",
    },
    740: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Neskaupstaður",
        "stadur_tgf": "Neskaupstað",
        "tegund": "Þéttbýli",
    },
    741: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Neskaupsstaður",
        "stadur_tgf": "Neskaupsstað",
        "tegund": "Dreifbýli",
    },
    750: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Fáskrúðsfjörður",
        "stadur_tgf": "Fáskrúðsfirði",
        "tegund": "Þéttbýli",
    },
    751: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Fáskrúðsfjörður",
        "stadur_tgf": "Fáskrúðsfirði",
        "tegund": "Dreifbýli",
    },
    755: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Stöðvarfjörður",
        "stadur_tgf": "Stöðvarfirði",
        "tegund": "Þéttbýli",
    },
    756: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Stöðvarfjörður",
        "stadur_tgf": "Stöðvarfirði",
        "tegund": "Dreifbýli",
    },
    760: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Breiðdalsvík",
        "stadur_tgf": "Breiðdalsvík",
        "tegund": "Þéttbýli",
    },
    761: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Breiðdalsvík",
        "stadur_tgf": "Breiðdalsvík",
        "tegund": "Dreifbýli",
    },
    765: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Djúpivogur",
        "stadur_tgf": "Djúpavogi",
        "tegund": "Þéttbýli",
    },
    766: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Djúpivogur",
        "stadur_tgf": "Djúpavogi",
        "tegund": "Dreifbýli",
    },
    780: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Höfn í Hornafirði",
        "stadur_tgf": "Höfn í Hornafirði",
        "tegund": "Þéttbýli",
    },
    781: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Höfn í Hornafirði",
        "stadur_tgf": "Höfn í Hornafirði",
        "tegund": "Dreifbýli",
    },
    785: {
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "stadur_nf": "Öræfi",
        "stadur_tgf": "Öræfum",
        "tegund": "Dreifbýli",
    },
    800: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "tegund": "Þéttbýli",
    },
    801: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "tegund": "Dreifbýli",
    },
    802: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "tegund": "Pósthólf",
    },
    803: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "tegund": "Þéttbýli",
    },
    804: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "tegund": "Þéttbýli",
    },
    805: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "tegund": "Þéttbýli",
    },
    806: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "tegund": "Þéttbýli",
    },
    810: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Hveragerði",
        "stadur_tgf": "Hveragerði",
        "tegund": "Þéttbýli",
    },
    815: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Þorlákshöfn",
        "stadur_tgf": "Þorlákshöfn",
        "tegund": "Þéttbýli",
    },
    816: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Ölfus",
        "stadur_tgf": "Ölfus",
        "tegund": "Dreifbýli",
    },
    820: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Eyrarbakki",
        "stadur_tgf": "Eyrarbakka",
        "tegund": "Þéttbýli",
    },
    825: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Stokkseyri",
        "stadur_tgf": "Stokkseyri",
        "tegund": "Þéttbýli",
    },
    840: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Laugarvatn",
        "stadur_tgf": "Laugarvatni",
        "tegund": "Þéttbýli",
    },
    845: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Flúðir",
        "stadur_tgf": "Flúðum",
        "tegund": "Þéttbýli",
    },
    846: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Flúðir",
        "stadur_tgf": "Flúðum",
        "tegund": "Dreifbýli",
    },
    850: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Hella",
        "stadur_tgf": "Hellu",
        "tegund": "Þéttbýli",
    },
    851: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Hella",
        "stadur_tgf": "Hellu",
        "tegund": "Dreifbýli",
    },
    860: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Hvolsvöllur",
        "stadur_tgf": "Hvolsvelli",
        "tegund": "Þéttbýli",
    },
    861: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Hvolsvöllur",
        "stadur_tgf": "Hvolsvelli",
        "tegund": "Dreifbýli",
    },
    870: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Vík",
        "stadur_tgf": "Vík",
        "tegund": "Þéttbýli",
    },
    871: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Vík",
        "stadur_tgf": "Vík",
        "tegund": "Dreifbýli",
    },
    880: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Kirkjubæjarklaustur",
        "stadur_tgf": "Kirkjubæjarklaustri",
        "tegund": "Þéttbýli",
    },
    881: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Kirkjubæjarklaustur",
        "stadur_tgf": "Kirkjubæjarklaustri",
        "tegund": "Dreifbýli",
    },
    900: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Vestmannaeyjar",
        "stadur_tgf": "Vestmannaeyjum",
        "tegund": "Þéttbýli",
    },
    902: {
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "stadur_nf": "Vestmannaeyjar",
        "stadur_tgf": "Vestmannaeyjum",
        "tegund": "Pósthólf",
    },
}


def postcode_lookup(postcode):
    """ Return postcode info dictionary given a postcode.
        Accepts either numeric or string argument. """
    return POSTCODES.get(int(postcode))


def postcodes_for_region(region_name, partial=False):
    """ Return postcodes matching a full or partial region name,
        e.g. "Norðurland", "Höfuðborgarsvæðið". """
    return _filter_postcodes("svaedi", region_name, partial=partial)


def postcodes_for_placename(placename, partial=False):
    """ Returns postcodes matching a full or partial placename,
        e.g. "Reykjavík", "Dalvík". """
    return _filter_postcodes("stadur", placename, partial=partial)


def _filter_postcodes(key, searchstr, partial=False):
    """ Utility function to find postcodes matching a criterion. """
    assert key in ["stadur", "svaedi"]
    p = searchstr.lower()
    matches = list()

    k1 = key + "_nf"
    k2 = key + "_tgf"

    for k, v in POSTCODES.items():
        nf = v[k1].lower()
        tgf = v[k2].lower()
        if partial and (nf.startswith(p) or tgf.startswith(p)):
            matches.append(k)
        elif nf == p or tgf == p:
            matches.append(k)

    return matches
