import * as cf from '@aws-cdk/aws-cloudfront';
import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
import { IExtensions } from './extensions';
/**
 * @stability stable
 */
export interface CustomProps {
    /**
     * Specify your Lambda function.
     *
     * You can specify your Lamba function
     * It's implement by lambda.Function, ex: NodejsFunction / PythonFunction or CustomFunction
     *
     * @stability stable
     */
    readonly func?: lambda.Function;
    /**
     * The source code of your Lambda function.
     *
     * You can point to a file in an
     * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
     * code as inline text.
     *
     * @default Code.fromAsset(path.join(__dirname, '../lambda/function'))
     * @stability stable
     */
    readonly code?: lambda.AssetCode;
    /**
     * The runtime environment for the Lambda function that you are uploading.
     *
     * For valid values, see the Runtime property in the AWS Lambda Developer
     * Guide.
     *
     * Use `Runtime.FROM_IMAGE` when when defining a function from a Docker image.
     *
     * @default Runtime.PYTHON_3_8
     * @stability stable
     */
    readonly runtime?: lambda.Runtime;
    /**
     * The name of the method within your code that Lambda calls to execute your function.
     *
     * The format includes the file name. It can also include
     * namespaces and other qualifiers, depending on the runtime.
     * For more information, see https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-features.html#gettingstarted-features-programmingmodel.
     *
     * Use `Handler.FROM_IMAGE` when defining a function from a Docker image.
     *
     * NOTE: If you specify your source code as inline text by specifying the
     * ZipFile property within the Code property, specify index.function_name as
     * the handler.
     *
     * @default index.lambda_handler
     * @stability stable
     */
    readonly handler?: string;
    /**
     * The function execution time (in seconds) after which Lambda terminates the function.
     *
     * Because the execution time affects cost, set this value
     * based on the function's expected execution time.
     *
     * @default Duration.seconds(5)
     * @stability stable
     */
    readonly timeout?: cdk.Duration;
    /**
     * The type of event in response to which should the function be invoked.
     *
     * @default LambdaEdgeEventType.ORIGIN_RESPONSE
     * @stability stable
     */
    readonly eventType?: cf.LambdaEdgeEventType;
    /**
     * Allows a Lambda function to have read access to the body content.
     *
     * Only valid for "request" event types (ORIGIN_REQUEST or VIEWER_REQUEST).
     *
     * @default false
     * @stability stable
     */
    readonly includeBody?: boolean;
    /**
     * The solution identifier.
     *
     * @default - no identifier
     * @stability stable
     */
    readonly solutionId?: string;
    /**
     * The template description.
     *
     * @default ''
     * @stability stable
     */
    readonly templateDescription?: string;
}
/**
 * Custom extension sample.
 *
 * @stability stable
 */
export declare class Custom extends cdk.NestedStack implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * Allows a Lambda function to have read access to the body content.
     *
     * @stability stable
     */
    readonly includeBody?: boolean;
    /**
     * @stability stable
     */
    readonly props: CustomProps;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: CustomProps);
    private _addDescription;
    private _outputSolutionId;
}
