# Copyright 2021 The KaiJIN Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
import numpy as np


templates = np.array([
    [-86.3382352941177, -113.444117647059, 86.3382352941177, 113.444117647059, 0.500000000000000],
    [-48.7500000000000, -65.2500000000000, 48.7500000000000, 65.2500000000000, 0.500000000000000],
    [-33.2500000000000, -43.7500000000000, 33.2500000000000, 43.7500000000000, 0.500000000000000],
    [-25.7500000000000, -33.7500000000000, 25.7500000000000, 33.7500000000000, 0.500000000000000],
    [-40.5000000000000, -54.5000000000000, 40.5000000000000, 54.5000000000000, 1],
    [-34.5000000000000, -43.5000000000000, 34.5000000000000, 43.5000000000000, 1],
    [-28.5000000000000, -38, 28.5000000000000, 38, 1],
    [-25.6589050000000, -31.3221500000000, 25.6589050000000, 31.3221500000000, 1],
    [-21.6137000000000, -27.5976700000000, 21.6137000000000, 27.5976700000000, 1],
    [-20, -22.5000000000000, 20, 22.5000000000000, 1],
    [-17.5000000000000, -25.5000000000000, 17.5000000000000, 25.5000000000000, 1],
    [-16.3279854000000, -20.8855500000000, 16.3279854000000, 20.8855500000000, 1],
    [-29.4755000000000, -34.4803000000000, 29.4755000000000, 34.4803000000000, 2],
    [-25.4202000000000, -37.1060900000000, 25.4202000000000, 37.1060900000000, 2],
    [-24.2118000000000, -30.2145600000000, 24.2118000000000, 30.2145600000000, 2],
    [-22.0129000000000, -24.7059000000000, 22.0129000000000, 24.7059000000000, 2],
    [-19.3142000000000, -28.0202000000000, 19.3142000000000, 28.0202000000000, 2],
    [-17.9677000000000, -22.7849000000000, 17.9677000000000, 22.7849000000000, 2],
    [-15.6123000000000, -19.5907000000000, 15.6123000000000, 19.5907000000000, 2],
    [-13.1842000000000, -18.3421000000000, 13.1842000000000, 18.3421000000000, 2],
    [-13.5027700000000, -15.0792000000000, 13.5027700000000, 15.0792000000000, 2],
    [-11.1091000000000, -16.4909000000000, 11.1091000000000, 16.4909000000000, 2],
    [-10.9768600000000, -14.0478000000000, 10.9768600000000, 14.0478000000000, 2],
    [-9.97219999999993, -12.4105000000000, 9.97219999999993, 12.4105000000000, 2],
    [-9.66129999999998, -10.6161000000000, 9.66129999999998, 10.6161000000000, 2]
])


def nms(dets, thresh):
  """
  Courtesy of Ross Girshick
  [https://github.com/rbgirshick/py-faster-rcnn/blob/master/lib/nms/py_cpu_nms.py]
  """
  x1 = dets[:, 0]
  y1 = dets[:, 1]
  x2 = dets[:, 2]
  y2 = dets[:, 3]
  scores = dets[:, 4]

  areas = (x2 - x1) * (y2 - y1)
  order = scores.argsort()[::-1]

  keep = []
  while order.size > 0:
    i = order[0]
    keep.append(int(i))
    xx1 = np.maximum(x1[i], x1[order[1:]])
    yy1 = np.maximum(y1[i], y1[order[1:]])
    xx2 = np.minimum(x2[i], x2[order[1:]])
    yy2 = np.minimum(y2[i], y2[order[1:]])

    w = np.maximum(0.0, xx2 - xx1)
    h = np.maximum(0.0, yy2 - yy1)
    inter = w * h
    ovr = inter / (areas[i] + areas[order[1:]] - inter)

    inds = np.where(ovr <= thresh)[0]
    order = order[inds + 1]

  return np.array(keep).astype(np.int)
