from enum import Enum


class ProviderName(Enum):
    AmazonAthena = "athena"
    AmazonRedshift = "redshift"
    ApacheDrill = "drill"
    ApacheDruid = "druid"
    ApacheHive = "hive"
    ApacheImpala = "impala"
    ApacheKylin = "kylin"
    ApachePinot = "pinot"
    ApacheSpark = "spark"
    AzureSqlDatabase = "azuresqldatabase"
    GcpBigQuery = "bigquery"
    ApacheCassandra = "cassandra"
    CockrouchDB = "cockrouchdb"
    Clickhouse = "clickhouse"
    Couchbase = "couchbase"
    Dremio = "dremio"
    DB2 = "db2"
    ElasticSearch = "elasticsearch"
    Exasol = "exasol"
    Kafka = "kafka"
    GoogleSheets = "googlesheets"
    GcpSpanner = "spanner"
    Greenplum = "greenplum"
    MySql = "mysql"
    MongoDb = "mongodb"
    Oracle = "oracle"
    PostgresSQL = "postgres"
    Presto = "presto"
    SAPHana = "hana"
    Snowflake = "snowflake"
    Singlestore = "singlestore"
    Sybase = "sybase"
    MSSqlServer = "mssqlserver"
    Sqlite = "sqlite"
    RabbitMQ = "rabbitmq"
    Teradata = "teradata"
    Vertica = "vertica"
    Odbc = "odbc"
    Informix = "informix"
    Neo4j = "neo4j"
    AliCloud = "alicloud"
    Azure = "azure"
    DigitalOcean = "digitalocean"
    Hetzner = "hetzner"
    Linode = "linode"
    Gcp = "gcp"
    Minio = "minio"
    Ovh = "ovh"
    Aws = "aws"
    Openstack = "openstack"
    FTP = "ftp"
    SFTP = "sftp"
    Dropbox = "dropbox"
    Box = "box"
    Dockerhub = "dockerhub"
    ImageRegistry = "image-registry"
    GitHub = "github"
    Bitbucket = "bitbucket"
    Gitlab = "gitlab"
    SmtpProvider = "smtp"
    Slack = "slack"
    Hipchat = "hipchat"
    Discord = "discord"
    PageDuty = "pagerduty"
    PushOver = "pushover"
    OpsGenie = "opsgenie"
    Webhook = "webook"
    VictorOps = "victorops"
    Flock = "flock"
    MSTeam = "msteam"
    MatterMost = "mattermost"
    Facebook = "facebook"
    Twitter = "twitter"
    UnknownProvider = "unknown"


class ConnectionCategory(Enum):
    General = "general"
    CloudProvider = "cloud"
    DockerImageRegistry = "docker-image-registry"
    Database = "database"
    Git = "git"
    Messaging = "messaging"
    ConnectionMessagerBroker = "message-broker"
    ConnectionGraphDatabase = "graph-database"
    ConnectionSocialMedia = "social-media"


class ConnectionConditionType(Enum):
    ConnectionReady = "Ready"
    ConnectionSaved = "Saved"


class Resource(Enum):
    CPU = "cpu"
    Memory = "memory"
    Storage = "storage"


class Verb(Enum):
    All = "*"
    Get = "get"
    List = "list"
    Watch = "watch"
    Create = "create"
    Update = "update"
    Patch = "patch"
    Delete = "delete"


class ResourceKind(Enum):
    Algorithm = "algorithms"
    Cloud = "clouds"
    MLFramework = "mlframeworks"
    PretrainedModel = "pretrainedmodels"
    PublicDataset = "publicdatasets"
    UserRoleClass = "userroleclasses"
    WorkloadClass = "workloadclasses"

    DataPipeline = "datapipelines"
    DataPipelineRun = "datapipelineruns"
    DataProduct = "dataproducts"
    DataProductVersion = "dataproductversions"
    Dataset = "datasets"
    DataSource = "datasources"
    Entity = "entities"
    Feature = "features"
    FeaturePipeline = "featurepipelines"
    FeaturePipelineRun = "featurepipelineruns"
    Featureset = "featuresets"
    FeatureHistogram = "featurehistograms"
    LabelingPipeline = "labelingpipelines"
    LabelingPipelineRun = "labelingpipelineruns"
    Recipe = "recipes"
    RecipeRun = "reciperuns"
    SqlQuery = "sqlqueries"
    SqlQueryRun = "sqlqueryruns"
    WebRequest = "webrequests"
    WebRequestRun = "webrequestruns"

    CronPrediction = "cronpredictions"
    Prediction = "predictions"
    Predictor = "predictors"
    Curtain = "curtains"
    DataApp = "dataapps"

    Account = "accounts"
    Alert = "alerts"
    ApiToken = "apitokens"
    Connection = "connections"
    Commit = "commits"
    Lab = "labs"
    License = "licenses"
    Notifier = "notifiers"
    ServingSite = "servingsites"
    Tenant = "tenants"
    VirtualBucket = "virtualbuckets"
    VirtualCluster = "virtualclusters"
    VirtualVolume = "virtualvolumes"
    Attachment = "attachments"

    Model = "models"
    Notebook = "notebooks"
    NotebookRun = "notebookruns"
    ModelPipeline = "modelpipelines"
    ModelPipelineRun = "modelpipelineruns"
    ModelCompilerRun = "modelcompilerruns"
    ModelAutobuilder = "modelautobuilders"
    Report = "reports"
    CronReport = "cronreports"
    Study = "studies"

    Review = "reviews"
    PostMortem = "postmortems"
    RunBook = "runbooks"
    Todo = "todos"
    Meeting = "meetings"

    Secret = "secrets"
    Deployment = "deployments"
    Service = "services"
    Pod = "pods"
    Job = "jobs"
