"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactTypeDef = exports.ReactComponent = exports.ReactTypeScriptProject = exports.ReactProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const file_1 = require("../file");
const node_project_1 = require("../node-project");
const sample_file_1 = require("../sample-file");
const source_code_1 = require("../source-code");
const tasks_1 = require("../tasks");
const typescript_1 = require("../typescript");
const typescript_config_1 = require("../typescript-config");
const util_1 = require("../util");
/**
 * (experimental) React project without TypeScript.
 *
 * @experimental
 * @pjid react
 */
class ReactProject extends node_project_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f;
        super({
            jest: false,
            ...options,
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        new ReactComponent(this, { typescript: false, rewire: options.rewire });
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if ((_f = options.sampleCode) !== null && _f !== void 0 ? _f : true) {
            new ReactSampleCode(this, {
                fileExt: 'jsx',
                srcdir: this.srcdir,
            });
        }
    }
}
exports.ReactProject = ReactProject;
_a = JSII_RTTI_SYMBOL_1;
ReactProject[_a] = { fqn: "projen.web.ReactProject", version: "0.23.2" };
/**
 * (experimental) React project with TypeScript.
 *
 * @experimental
 * @pjid react-ts
 */
class ReactTypeScriptProject extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f, _g;
        const defaultOptions = {
            srcdir: 'src',
            eslint: false,
            jest: false,
            tsconfig: {
                include: ['src'],
                compilerOptions: {
                    target: 'es5',
                    lib: [
                        'dom',
                        'dom.iterable',
                        'esnext',
                    ],
                    allowJs: true,
                    skipLibCheck: true,
                    esModuleInterop: true,
                    allowSyntheticDefaultImports: true,
                    strict: true,
                    forceConsistentCasingInFileNames: true,
                    noFallthroughCasesInSwitch: true,
                    module: 'esnext',
                    moduleResolution: typescript_config_1.TypeScriptModuleResolution.NODE,
                    resolveJsonModule: true,
                    isolatedModules: true,
                    noEmit: true,
                    jsx: typescript_config_1.TypeScriptJsxMode.REACT_JSX,
                },
            },
            typescriptVersion: (_e = options.typescriptVersion) !== null && _e !== void 0 ? _e : '^4.0.3',
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([defaultOptions, options, { sampleCode: false }]));
        this.srcdir = (_f = options.srcdir) !== null && _f !== void 0 ? _f : 'src';
        new ReactComponent(this, { typescript: true, rewire: options.rewire });
        this.reactTypeDef = new ReactTypeDef(this, 'react-app-env.d.ts');
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if ((_g = options.sampleCode) !== null && _g !== void 0 ? _g : true) {
            new ReactSampleCode(this, {
                fileExt: 'tsx',
                srcdir: this.srcdir,
            });
        }
    }
}
exports.ReactTypeScriptProject = ReactTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
ReactTypeScriptProject[_b] = { fqn: "projen.web.ReactTypeScriptProject", version: "0.23.2" };
/**
 * @experimental
 */
class ReactComponent extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _e, _f, _g;
        super(project);
        this.typescript = (_e = options.typescript) !== null && _e !== void 0 ? _e : false;
        // No compile for react app
        project.compileTask.reset();
        project.addDeps('react', 'react-dom', 'react-scripts@^4.0.0', 'web-vitals');
        project.addDevDeps('@testing-library/jest-dom', '@testing-library/react', '@testing-library/user-event');
        if (this.typescript) {
            project.addDevDeps('@types/jest', '@types/react', '@types/react-dom');
        }
        const rewire = (_f = options.rewire) !== null && _f !== void 0 ? _f : false;
        if (rewire) {
            const overridesPath = '.projen/react-config-overrides.js';
            project.addDevDeps('react-app-rewired');
            project.addFields({ 'config-overrides-path': overridesPath });
            const configOverrides = new source_code_1.SourceCode(this.project, overridesPath);
            configOverrides.line(`// ${file_1.FileBase.PROJEN_MARKER}`);
            configOverrides.line('/**');
            configOverrides.line(' * Override CRA configuration without needing to eject.');
            configOverrides.line(' *');
            configOverrides.line(' * @see https://www.npmjs.com/package/react-app-rewired');
            configOverrides.line(' */');
            configOverrides.open('module.exports = function override(config, env) {');
            for (const [key, value] of Object.entries(rewire)) {
                configOverrides.line(`config.${key} = ${JSON.stringify(value)};`);
            }
            configOverrides.line('return config;');
            configOverrides.close('};');
        }
        const reactScripts = rewire ? 'react-app-rewired' : 'react-scripts';
        // Create React App CLI commands, see: https://create-react-app.dev/docs/available-scripts/
        project.addTask('dev', {
            description: 'Starts the react application',
            category: tasks_1.TaskCategory.BUILD,
            exec: `${reactScripts} start`,
        });
        project.buildTask.exec(`${reactScripts} build`);
        project.addTask('eject', {
            description: 'Ejects your React application from react-scripts',
            category: tasks_1.TaskCategory.MISC,
            // eject is not necessary to rewire
            exec: 'react-scripts eject',
        });
        project.testTask.exec(`${reactScripts} test --watchAll=false`);
        const testWatch = project.tasks.tryFind('test:watch');
        testWatch === null || testWatch === void 0 ? void 0 : testWatch.reset(`${reactScripts} test`);
        (_g = project.npmignore) === null || _g === void 0 ? void 0 : _g.exclude('# Build', '/build');
        project.gitignore.exclude('# Build', '/build');
        project.package.addField('eslintConfig', {
            extends: [
                'react-app',
                'react-app/jest',
            ],
        });
        project.package.addField('browserslist', {
            production: [
                '>0.2%',
                'not dead',
                'not op_mini all',
            ],
            development: [
                'last 1 chrome version',
                'last 1 firefox version',
                'last 1 safari version',
            ],
        });
    }
}
exports.ReactComponent = ReactComponent;
_c = JSII_RTTI_SYMBOL_1;
ReactComponent[_c] = { fqn: "projen.web.ReactComponent", version: "0.23.2" };
class ReactSampleCode extends component_1.Component {
    constructor(project, options) {
        var _e;
        super(project);
        this.fileExt = (_e = options.fileExt) !== null && _e !== void 0 ? _e : 'jsx';
        this.srcdir = options.srcdir;
        const logoSvg = [
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3">',
            '    <g fill="#61DAFB">',
            '        <path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/>',
            '        <circle cx="420.9" cy="296.5" r="45.7"/>',
            '        <path d="M520.5 78.1z"/>',
            '    </g>',
            '</svg>',
            '',
        ];
        const appJsx = [
            "import logo from './logo.svg';",
            "import './App.css'",
            '',
            'function App() {',
            '  return (',
            '   <div className="App">',
            '      <header className="App-header">',
            '        <img src={logo} className="App-logo" alt="logo" />',
            '        <p>',
            `          Edit <code>src/App.${this.fileExt}</code> and save to reload.`,
            '        </p>',
            '        <a className="App-link"',
            '          href="https://reactjs.org"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            '        >',
            '          Learn React',
            '        </a>',
            '      </header>',
            '    </div>',
            '  );',
            '}',
            '',
            'export default App;',
            '',
        ];
        const appCss = [
            '.App {',
            '  text-align: center;',
            '}',
            '',
            '.App-logo {',
            '  height: 40vmin;',
            '  pointer-events: none;',
            '}',
            '',
            '@media (prefers-reduced-motion: no-preference) {',
            '  .App-logo {',
            '    animation: App-logo-spin infinite 20s linear;',
            '  }',
            '}',
            '',
            '.App-header {',
            '  background-color: #282c34;',
            '  min-height: 100vh;',
            '  display: flex;',
            '  flex-direction: column;',
            '  align-items: center;',
            '  justify-content: center;',
            '  font-size: calc(10px + 2vmin);',
            '  color: white;',
            '}',
            '',
            '.App-link {',
            '  color: #61dafb;',
            '}',
            '',
            '@keyframes App-logo-spin {',
            '  from {',
            '    transform: rotate(0deg);',
            '  }',
            '  to {',
            '    transform: rotate(360deg);',
            '  }',
            '}',
            '',
        ];
        const appTestJsx = [
            "import React from 'react';",
            "import { render, screen } from '@testing-library/react';",
            "import App from './App';",
            '',
            "test('renders learn react link', () => {",
            '  render(<App />);',
            '  const linkElement = screen.getByText(/learn react/i);',
            '  expect(linkElement).toBeInTheDocument();',
            '});',
            '',
        ];
        const indexJsx = [
            "import React from 'react';",
            "import ReactDOM from 'react-dom';",
            "import './index.css';",
            "import App from './App';",
            "import reportWebVitals from './reportWebVitals';",
            '',
            'ReactDOM.render(',
            '  <React.StrictMode>',
            '    <App />',
            '  </React.StrictMode>,',
            "  document.getElementById('root')",
            ');',
            '',
            '// If you want to start measuring performance in your app, pass a function',
            '// to log results (for example: reportWebVitals(console.log))',
            '// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals',
            'reportWebVitals();',
            '',
        ];
        const indexCss = [
            'body {',
            '  margin: 0;',
            "  font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen',",
            "    'Ubuntu', 'Cantarell', 'Fira Sans', 'Droid Sans', 'Helvetica Neue',",
            '    sans-serif;',
            '  -webkit-font-smoothing: antialiased;',
            '  -moz-osx-font-smoothing: grayscale;',
            '}',
            '',
            'code {',
            "  font-family: source-code-pro, Menlo, Monaco, Consolas, 'Courier New',",
            '    monospace;',
            '}',
            '',
        ];
        const reportWebVitalsJs = [
            "import { ReportHandler } from 'web-vitals';",
            '',
            'const reportWebVitals = (onPerfEntry?: ReportHandler) => {',
            '  if (onPerfEntry && onPerfEntry instanceof Function) {',
            "    import('web-vitals').then(({ getCLS, getFID, getFCP, getLCP, getTTFB }) => {",
            '      getCLS(onPerfEntry);',
            '      getFID(onPerfEntry);',
            '      getFCP(onPerfEntry);',
            '      getLCP(onPerfEntry);',
            '      getTTFB(onPerfEntry);',
            '    });',
            '  }',
            '}',
            '',
            'export default reportWebVitals;',
        ];
        const setupTestsJs = [
            '// jest-dom adds custom jest matchers for asserting on DOM nodes.',
            '// allows you to do things like:',
            '// expect(element).toHaveTextContent(/react/i)',
            '// learn more: https://github.com/testing-library/jest-dom',
            "import '@testing-library/jest-dom';",
            '',
        ];
        // js/ts not jsx/tsx
        const fileExtWithoutX = this.fileExt.replace('x', '');
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                'logo.svg': logoSvg.join('\n'),
                ['App.' + this.fileExt]: appJsx.join('\n'),
                ['App.test.' + this.fileExt]: appTestJsx.join('\n'),
                'App.css': appCss.join('\n'),
                ['index.' + this.fileExt]: indexJsx.join('\n'),
                'index.css': indexCss.join('\n'),
                ['reportWebVitals.' + fileExtWithoutX]: reportWebVitalsJs.join('\n'),
                ['setupTests.' + fileExtWithoutX]: setupTestsJs.join('\n'),
            },
        });
        const indexHtml = [
            '<!DOCTYPE html>',
            '<html lang="en">',
            '  <head>',
            '    <meta charset="utf-8" />',
            '    <link rel="icon" href="%PUBLIC_URL%/favicon.ico" />',
            '    <meta name = "viewport" content = "width=device-width, initial-scale=1" />',
            '    <meta name="theme-color" content = "#000000" />',
            '    <meta name="description" content = "Web site created using create-react-app" />',
            '    <link rel="apple-touch-icon" href = "%PUBLIC_URL%/logo192.png" />',
            '    <!--',
            '      manifest.json provides metadata used when your web app is installed on a',
            "      user's mobile device or desktop. See https://developers.google.com/web/fundamentals/web-app-manifest/",
            '    -->',
            '    <link rel="manifest" href = "%PUBLIC_URL%/manifest.json" />',
            '    <!--',
            '      Notice the use of % PUBLIC_URL % in the tags above.',
            '      It will be replaced with the URL of the`public` folder during the build.',
            '      Only files inside the`public` folder can be referenced from the HTML.',
            '',
            '      Unlike "/favicon.ico" or "favicon.ico", "%PUBLIC_URL%/favicon.ico" will',
            '      work correctly both with client - side routing and a non - root public URL.',
            '      Learn how to configure a non-root public URL by running`npm run build`.',
            '    -->',
            '    <title>React App </title>',
            '  </head>',
            '  <body>',
            '    <noscript>You need to enable JavaScript to run this app.</noscript>',
            '    <div id="root"> </div>',
            '    <!--',
            '      This HTML file is a template.',
            '      If you open it directly in the browser, you will see an empty page.',
            '      You can add webfonts, meta tags, or analytics to this file.',
            '      The build step will place the bundled scripts into the <body> tag.',
            '',
            '      To begin the development, run `npm start` or `yarn start`.',
            '      To create a production bundle, use `npm run build` or `yarn build`.',
            '    -->',
            '  </body>',
            '</html>',
        ];
        const publicManifest = {
            short_name: 'React App',
            name: 'Create React App Sample',
            icons: [],
            start_url: '.',
            display: 'standalone',
            theme_color: '#000000',
            background_color: '#ffffff',
        };
        const robotTxt = [
            '# https://www.robotstxt.org/robotstxt.html',
            'User-agent: *',
            'Disallow:',
        ];
        new sample_file_1.SampleDir(project, 'public', {
            files: {
                'index.html': indexHtml.join('\n'),
                'manifest.json': JSON.stringify(publicManifest, undefined, 2),
                'robots.txt': robotTxt.join('\n'),
            },
        });
    }
}
/**
 * @experimental
 */
class ReactTypeDef extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        return [
            '/// <reference types="react-scripts" />',
        ].join('\n');
    }
}
exports.ReactTypeDef = ReactTypeDef;
_d = JSII_RTTI_SYMBOL_1;
ReactTypeDef[_d] = { fqn: "projen.web.ReactTypeDef", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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