"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NextComponent = exports.NextJsTypeDef = exports.NextJsTypeScriptProject = exports.NextJsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const file_1 = require("../file");
const node_project_1 = require("../node-project");
const sample_file_1 = require("../sample-file");
const tasks_1 = require("../tasks");
const typescript_1 = require("../typescript");
const typescript_config_1 = require("../typescript-config");
const util_1 = require("../util");
const postcss_1 = require("./postcss");
/**
 * (experimental) Next.js project without TypeScript.
 *
 * @experimental
 * @pjid nextjs
 */
class NextJsProject extends node_project_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f, _g, _h;
        super({
            jest: false,
            minNodeVersion: '12.13.0',
            ...options,
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'pages';
        this.assetsdir = (_f = options.assetsdir) !== null && _f !== void 0 ? _f : 'public';
        this.tailwind = (_g = options.tailwind) !== null && _g !== void 0 ? _g : true;
        new NextComponent(this, { typescript: false, tailwind: this.tailwind });
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if ((_h = options.sampleCode) !== null && _h !== void 0 ? _h : true) {
            new NextSampleCode(this, {
                fileExt: 'js',
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsProject = NextJsProject;
_a = JSII_RTTI_SYMBOL_1;
NextJsProject[_a] = { fqn: "projen.web.NextJsProject", version: "0.23.2" };
/**
 * (experimental) Next.js project with TypeScript.
 *
 * @experimental
 * @pjid nextjs-ts
 */
class NextJsTypeScriptProject extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f, _g, _h;
        const defaultOptions = {
            srcdir: 'pages',
            eslint: false,
            minNodeVersion: '12.13.0',
            jest: false,
            tsconfig: {
                include: ['**/*.ts', '**/*.tsx'],
                compilerOptions: {
                    // required by Next.js
                    esModuleInterop: true,
                    module: 'esnext',
                    moduleResolution: typescript_config_1.TypeScriptModuleResolution.NODE,
                    isolatedModules: true,
                    resolveJsonModule: true,
                    jsx: typescript_config_1.TypeScriptJsxMode.PRESERVE,
                    // recommended by Next.js
                    allowJs: true,
                    skipLibCheck: true,
                    forceConsistentCasingInFileNames: true,
                    noEmit: true,
                    lib: ['dom', 'dom.iterable', 'esnext'],
                    strict: false,
                    target: 'es5',
                },
            },
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([defaultOptions, options, { sampleCode: false }]));
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'pages';
        this.assetsdir = (_f = options.assetsdir) !== null && _f !== void 0 ? _f : 'public';
        this.tailwind = (_g = options.tailwind) !== null && _g !== void 0 ? _g : true;
        new NextComponent(this, { typescript: true, tailwind: this.tailwind });
        // 'next build' command fails if tsconfig.json is immutable
        if (this.tsconfig) {
            this.tsconfig.file.readonly = false;
        }
        this.nextJsTypeDef = new NextJsTypeDef(this, 'next-env.d.ts');
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if ((_h = options.sampleCode) !== null && _h !== void 0 ? _h : true) {
            new NextSampleCode(this, {
                fileExt: 'tsx',
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsTypeScriptProject = NextJsTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
NextJsTypeScriptProject[_b] = { fqn: "projen.web.NextJsTypeScriptProject", version: "0.23.2" };
/**
 * @experimental
 */
class NextJsTypeDef extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        return [
            '/// <reference types="next" />',
            '/// <reference types="next/types/global" />',
        ].join('\n');
    }
}
exports.NextJsTypeDef = NextJsTypeDef;
_c = JSII_RTTI_SYMBOL_1;
NextJsTypeDef[_c] = { fqn: "projen.web.NextJsTypeDef", version: "0.23.2" };
/**
 * @experimental
 */
class NextComponent extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _e, _f, _g;
        super(project);
        this.typescript = (_e = options.typescript) !== null && _e !== void 0 ? _e : false;
        this.tailwind = (_f = options.tailwind) !== null && _f !== void 0 ? _f : true;
        project.addDeps('next', 'react', 'react-dom');
        if (this.typescript) {
            project.addDevDeps('@types/react', '@types/react-dom');
        }
        if (this.tailwind) {
            new postcss_1.PostCss(project, { tailwind: true });
        }
        // NextJS CLI commands, see: https://nextjs.org/docs/api-reference/cli
        project.addTask('dev', {
            description: 'Starts the Next.js application in development mode',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'next dev',
        });
        project.buildTask.exec('next build');
        project.addTask('export', {
            description: 'Exports the application for production deployment',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'next export',
        });
        project.addTask('server', {
            description: 'Starts the Next.js application in production mode',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'next start',
        });
        project.addTask('telemetry', {
            description: 'Checks the status of Next.js telemetry collection',
            category: tasks_1.TaskCategory.MISC,
            exec: 'next telemetry',
        });
        (_g = project.npmignore) === null || _g === void 0 ? void 0 : _g.exclude('# Next.js', '/.next/');
        project.gitignore.exclude('# Next.js', '/.next/');
    }
}
exports.NextComponent = NextComponent;
_d = JSII_RTTI_SYMBOL_1;
NextComponent[_d] = { fqn: "projen.web.NextComponent", version: "0.23.2" };
class NextSampleCode extends component_1.Component {
    constructor(project, options) {
        var _e;
        super(project);
        this.fileExt = (_e = options.fileExt) !== null && _e !== void 0 ? _e : 'js';
        this.srcdir = options.srcdir;
        this.assetsdir = options.assetsdir;
        this.tailwind = options.tailwind;
        const indexJs = [
            'import Head from "next/head"',
            '',
            'export default function Home() {',
            '  return (',
            '    <div className="container">',
            '      <Head>',
            '        <title>Create Next App</title>',
            '      </Head>',
            '',
            '      <main>',
            '        <h1 className="title">',
            '          Welcome to <a href="https://nextjs.org">Next.js!</a>',
            '        </h1>',
            '',
            '        <p className="description">',
            '          Get started by editing <code>pages/index.js</code>',
            '        </p>',
            '',
            '        <div className="grid">',
            '          <a href="https://nextjs.org/docs" className="card">',
            '            <h3>Documentation &rarr;</h3>',
            '            <p>Find in-depth information about Next.js features and API.</p>',
            '          </a>',
            '',
            '          <a href="https://nextjs.org/learn" className="card">',
            '            <h3>Learn &rarr;</h3>',
            '            <p>Learn about Next.js in an interactive course with quizzes!</p>',
            '          </a>',
            '',
            '          <a',
            '            href="https://github.com/vercel/next.js/tree/master/examples"',
            '            className="card"',
            '          >',
            '            <h3>Examples &rarr;</h3>',
            '            <p>Discover and deploy boilerplate example Next.js projects.</p>',
            '          </a>',
            '',
            '          <a',
            '            href="https://vercel.com/import?filter=next.js&utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '            className="card"',
            '          >',
            '            <h3>Deploy &rarr;</h3>',
            '            <p>',
            '              Instantly deploy your Next.js site to a public URL with Vercel.',
            '            </p>',
            '          </a>',
            '        </div>',
            '      </main>',
            '',
            '      <footer>',
            '        <a',
            '          href="https://vercel.com?utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            '        >',
            '          Powered by Vercel',
            '          <img src="/vercel.svg" alt="Vercel Logo" className="logo" />',
            '        </a>',
            '      </footer>',
            '',
            '      <style jsx>{`',
            '        .container {',
            '          min-height: 100vh;',
            '          padding: 0 0.5rem;',
            '          display: flex;',
            '          flex-direction: column;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        main {',
            '          padding: 5rem 0;',
            '          flex: 1;',
            '          display: flex;',
            '          flex-direction: column;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        footer {',
            '          width: 100%;',
            '          height: 100px;',
            '          border-top: 1px solid #eaeaea;',
            '          display: flex;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        footer img {',
            '          margin-left: 0.5rem;',
            '        }',
            '',
            '        footer a {',
            '          display: flex;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        a {',
            '          color: inherit;',
            '          text-decoration: none;',
            '        }',
            '',
            '        .title a {',
            '          color: #0070f3;',
            '          text-decoration: none;',
            '        }',
            '',
            '        .title a:hover,',
            '        .title a:focus,',
            '        .title a:active {',
            '          text-decoration: underline;',
            '        }',
            '',
            '        .title {',
            '          margin: 0;',
            '          line-height: 1.15;',
            '          font-size: 4rem;',
            '        }',
            '',
            '        .title,',
            '        .description {',
            '          text-align: center;',
            '        }',
            '',
            '        .description {',
            '          line-height: 1.5;',
            '          font-size: 1.5rem;',
            '        }',
            '',
            '        code {',
            '          background: #fafafa;',
            '          border-radius: 5px;',
            '          padding: 0.75rem;',
            '          font-size: 1.1rem;',
            '          font-family: Menlo, Monaco, Lucida Console, Liberation Mono,',
            '            DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;',
            '        }',
            '',
            '        .grid {',
            '          display: flex;',
            '          align-items: center;',
            '          justify-content: center;',
            '          flex-wrap: wrap;',
            '',
            '          max-width: 800px;',
            '          margin-top: 3rem;',
            '        }',
            '',
            '        .card {',
            '          margin: 1rem;',
            '          flex-basis: 45%;',
            '          padding: 1.5rem;',
            '          text-align: left;',
            '          color: inherit;',
            '          text-decoration: none;',
            '          border: 1px solid #eaeaea;',
            '          border-radius: 10px;',
            '          transition: color 0.15s ease, border-color 0.15s ease;',
            '        }',
            '',
            '        .card:hover,',
            '        .card:focus,',
            '        .card:active {',
            '          color: #0070f3;',
            '          border-color: #0070f3;',
            '        }',
            '',
            '        .card h3 {',
            '          margin: 0 0 1rem 0;',
            '          font-size: 1.5rem;',
            '        }',
            '',
            '        .card p {',
            '          margin: 0;',
            '          font-size: 1.25rem;',
            '          line-height: 1.5;',
            '        }',
            '',
            '        .logo {',
            '          height: 1em;',
            '        }',
            '',
            '        @media (max-width: 600px) {',
            '          .grid {',
            '            width: 100%;',
            '            flex-direction: column;',
            '          }',
            '        }',
            '      `}</style>',
            '',
            '      <style jsx global>{`',
            '        html,',
            '        body {',
            '          padding: 0;',
            '          margin: 0;',
            '          font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto,',
            '            Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue,',
            '            sans-serif;',
            '        }',
            '',
            '        * {',
            '          box-sizing: border-box;',
            '        }',
            '      `}</style>',
            '    </div>',
            '  )',
            '}',
            '',
        ];
        if (this.tailwind) {
            indexJs.unshift('import "tailwindcss/tailwind.css"');
        }
        const vercelSvg = [
            '<svg width="283" height="64" viewBox="0 0 283 64" fill="none" ',
            '    xmlns="http://www.w3.org/2000/svg">',
            '    <path d="M141.04 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.46 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM248.72 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.45 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM200.24 34c0 6 3.92 10 10 10 4.12 0 7.21-1.87 8.8-4.92l7.68 4.43c-3.18 5.3-9.14 8.49-16.48 8.49-11.05 0-19-7.2-19-18s7.96-18 19-18c7.34 0 13.29 3.19 16.48 8.49l-7.68 4.43c-1.59-3.05-4.68-4.92-8.8-4.92-6.07 0-10 4-10 10zm82.48-29v46h-9V5h9zM36.95 0L73.9 64H0L36.95 0zm92.38 5l-27.71 48L73.91 5H84.3l17.32 30 17.32-30h10.39zm58.91 12v9.69c-1-.29-2.06-.49-3.2-.49-5.81 0-10 4-10 10V51h-9V17h9v9.2c0-5.08 5.91-9.2 13.2-9.2z" fill="#000"/>',
            '</svg>',
        ];
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                ['index.' + this.fileExt]: indexJs.join('\n'),
            },
        });
        new sample_file_1.SampleDir(project, this.assetsdir, {
            files: {
                'vercel.svg': vercelSvg.join('\n'),
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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