"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const tasks_1 = require("./tasks");
/**
 * @experimental
 */
class Version extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.changelogFile = '.changelog.tmp.md';
        // this command determines if there were any changes since the last release
        // (the top-most commit is not a bump). it is used as a condition for both
        // the `bump` and the `release` tasks.
        const changesSinceLastRelease = '! git log --oneline -1 | grep -q "chore(release):"';
        const env = {
            OUTFILE: options.versionFile,
            CHANGELOG: this.changelogFile,
        };
        this.bumpTask = project.addTask('bump', {
            description: 'Bumps version based on latest git tag and generates a changelog entry',
            category: tasks_1.TaskCategory.RELEASE,
            condition: changesSinceLastRelease,
            env: env,
        });
        this.bumpTask.builtin('release/bump-version');
        this.unbumpTask = project.addTask('unbump', {
            description: 'Restores version to 0.0.0',
            category: tasks_1.TaskCategory.RELEASE,
            env: env,
        });
        this.unbumpTask.builtin('release/reset-version');
        project.addGitIgnore(`/${this.changelogFile}`);
        project.addPackageIgnore(`/${this.changelogFile}`);
    }
}
exports.Version = Version;
_a = JSII_RTTI_SYMBOL_1;
Version[_a] = { fqn: "projen.Version", version: "0.23.2" };
/**
 * @experimental
 */
Version.STANDARD_VERSION = 'standard-version@^9';
//# sourceMappingURL=data:application/json;base64,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