"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("../component");
const render_options_1 = require("../javascript/render-options");
const typescript_1 = require("../typescript");
/**
 * (experimental) Sets up a typescript project to use TypeScript for projenrc.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e;
        super(project);
        this.rcfile = (_b = options.filename) !== null && _b !== void 0 ? _b : '.projenrc.ts';
        // tell eslint to take .projenrc.ts into account as a dev-dependency
        (_c = project.eslint) === null || _c === void 0 ? void 0 : _c.allowDevDeps(this.rcfile);
        (_d = project.eslint) === null || _d === void 0 ? void 0 : _d.addIgnorePattern(`!${this.rcfile}`);
        (_e = project.tsconfigEslint) === null || _e === void 0 ? void 0 : _e.addInclude(this.rcfile);
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        project.addDevDeps('ts-node@^9');
        project.addTask(typescript_1.TypeScriptProject.DEFAULT_TASK, { exec: `ts-node ${this.rcfile}` });
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.newProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split('.');
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join('.');
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(importName);
        const lines = new Array();
        lines.push(`import { ${[...imports].sort().join(', ')} } from '${moduleName}';`);
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push('project.synth();');
        fs_1.writeFileSync(rcfile, lines.join('\n'));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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