"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourceCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const textfile_1 = require("./textfile");
/**
 * (experimental) Represents a source file.
 *
 * @experimental
 */
class SourceCode extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        var _b;
        super(project);
        this.indentLevel = 0;
        this.indent = (_b = options.indent) !== null && _b !== void 0 ? _b : 2;
        this.file = new textfile_1.TextFile(project, filePath);
    }
    /**
     * (experimental) Emit a line of code.
     *
     * @param code The contents, if not specified, just adds a newline.
     * @experimental
     */
    line(code) {
        const spaces = this.indent * this.indentLevel;
        const prefix = ' '.repeat(spaces);
        this.file.addLine(prefix + (code !== null && code !== void 0 ? code : ''));
    }
    /**
     * (experimental) Opens a code block and increases the indentation level.
     *
     * @param code The code before the block starts (e.g. `export class {`).
     * @experimental
     */
    open(code) {
        if (code) {
            this.line(code);
        }
        this.indentLevel++;
    }
    /**
     * (experimental) Decreases the indentation level and closes a code block.
     *
     * @param code The code after the block is closed (e.g. `}`).
     * @experimental
     */
    close(code) {
        if (this.indentLevel === 0) {
            throw new Error('Cannot decrease indent level below zero');
        }
        this.indentLevel--;
        if (code) {
            this.line(code);
        }
    }
}
exports.SourceCode = SourceCode;
_a = JSII_RTTI_SYMBOL_1;
SourceCode[_a] = { fqn: "projen.SourceCode", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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