"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SampleDir = exports.SampleFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("./component");
const util_1 = require("./util");
/**
 * (experimental) Produces a file with the given contents but only once, if the file doesn't already exist.
 *
 * Use this for creating example code files or other resources.
 *
 * @experimental
 */
class SampleFile extends component_1.Component {
    /**
     * (experimental) Creates a new SampleFile object.
     *
     * @param project - the project to tie this file to.
     * @param filePath - the relative path in the project o put the file.
     * @param options - the options for the file.
     * @experimental
     */
    constructor(project, filePath, options) {
        super(project);
        this.filePath = filePath;
        this.options = options;
    }
    /**
     * (experimental) Synthesizes files to the project output directory.
     *
     * @experimental
     */
    synthesize() {
        const contents = this.options.contents;
        this.writeOnceFileContents(this.project.outdir, this.filePath, contents !== null && contents !== void 0 ? contents : '');
    }
    /**
     * A helper function that will write the file once and return if it was written or not.
     * @param dir - the directory for the new file
     * @param filename - the filename for the new file
     * @param contents - the contents of the file to write
     * @return boolean - whether a new file was written or not.
     * @private
     */
    writeOnceFileContents(dir, filename, contents) {
        const fullFilename = path.join(dir, filename);
        if (fs.existsSync(fullFilename)) {
            return;
        }
        util_1.writeFile(fullFilename, contents, { readonly: false });
    }
}
exports.SampleFile = SampleFile;
_a = JSII_RTTI_SYMBOL_1;
SampleFile[_a] = { fqn: "projen.SampleFile", version: "0.23.2" };
/**
 * (experimental) Renders the given files into the directory if the directory does not exist.
 *
 * Use this to create sample code files
 *
 * @experimental
 */
class SampleDir extends component_1.Component {
    /**
     * (experimental) Create sample files in the given directory if the given directory does not exist.
     *
     * @param project Parent project to add files to.
     * @param dir directory to add files to.
     * @param options options for which files to create.
     * @experimental
     */
    constructor(project, dir, options) {
        super(project);
        this.dir = dir;
        this.options = options;
    }
    /**
     * (experimental) Synthesizes files to the project output directory.
     *
     * @experimental
     */
    synthesize() {
        const fullOutdir = path.join(this.project.outdir, this.dir);
        if (fs.pathExistsSync(fullOutdir)) {
            return;
        }
        for (const filename in this.options.files) {
            util_1.writeFile(path.join(fullOutdir, filename), this.options.files[filename]);
        }
    }
}
exports.SampleDir = SampleDir;
_b = JSII_RTTI_SYMBOL_1;
SampleDir[_b] = { fqn: "projen.SampleDir", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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