"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Resolves the latest version from git tags and uses `standard-version` to bump
 * to the next version based on commits.
 *
 * This expects `standard-version` to be installed in the path.
 *
 * Environment variables:
 *
 * - OUTFILE: (required) the name of the JSON output file (the "version" field
 *   will be updated with the latest version)
 * - PRERELEASE: (optional) a prerelease tag to use (e.g. "beta")
 * - MAJOR: major version number NN to filter (tags are filtered by "vNN."
 *   prefix). if not specified, the last major version is selected
 * - CHANGELOG: name of changelog file to create
 *
 */
const bump_version_1 = require("./bump-version");
const versionFile = process.env.OUTFILE;
const prerelease = process.env.PRERELEASE;
const major = process.env.MAJOR;
const changelog = process.env.CHANGELOG;
if (!versionFile) {
    throw new Error('OUTFILE is required');
}
if (!changelog) {
    throw new Error('CHANGELOG is required');
}
const majorVersion = (major == null || major === '') ? undefined : parseInt(major);
if (majorVersion === NaN) {
    throw new Error(`MAJOR must be a number: ${majorVersion}`);
}
const opts = {
    versionFile: versionFile,
    changelog: changelog,
    majorVersion: majorVersion,
    prerelease: prerelease,
};
bump_version_1.bump(process.cwd(), opts).catch((e) => {
    console.log(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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