"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Venv = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("../component");
const util_1 = require("../util");
/**
 * (experimental) Manages a virtual environment through the Python venv module.
 *
 * @experimental
 */
class Venv extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        this.envdir = (_b = options.envdir) !== null && _b !== void 0 ? _b : '.env';
        this.project.gitignore.exclude(`/${this.envdir}`);
        this.project.tasks.addEnvironment('VIRTUAL_ENV', `$(echo $PWD/${this.envdir})`);
        this.project.tasks.addEnvironment('PATH', `$(echo $PWD/${this.envdir}/bin:$PATH)`);
    }
    /**
     * (experimental) Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     *
     * @experimental
     */
    setupEnvironment() {
        const absoluteEnvdir = path.join(this.project.outdir, this.envdir);
        if (!fs.pathExistsSync(absoluteEnvdir)) {
            this.project.logger.info('Setting up a virtual environment...');
            util_1.exec(`python -m venv ${this.envdir}`, { cwd: this.project.outdir });
            this.project.logger.info(`Environment successfully created (located in ./${this.envdir}).`);
        }
    }
}
exports.Venv = Venv;
_a = JSII_RTTI_SYMBOL_1;
Venv[_a] = { fqn: "projen.python.Venv", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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