"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pytest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
const tasks_1 = require("../tasks");
/**
 * @experimental
 */
class Pytest extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        const version = (_b = options.version) !== null && _b !== void 0 ? _b : '6.2.1';
        project.addDevDependency(`pytest@${version}`);
        this.testTask = project.addTask('test', {
            description: 'Runs tests',
            category: tasks_1.TaskCategory.TEST,
            exec: [
                'pytest',
                ...(options.maxFailures ? [`--maxfail=${options.maxFailures}`] : []),
            ].join(' '),
        });
        new sample_file_1.SampleDir(project, 'tests', {
            files: {
                '__init__.py': '',
                'test_example.py': [
                    'import pytest',
                    '',
                    `from ${project.moduleName}.example import hello`,
                    '',
                    '@pytest.mark.parametrize(',
                    '    ("name", "expected"),',
                    '    [',
                    '        ("A. Musing", "Hello A. Musing!"),',
                    '        ("traveler", "Hello traveler!"),',
                    '        ("projen developer", "Hello projen developer!"),',
                    '    ],',
                    ')',
                    'def test_hello(name, expected):',
                    '    """Example test with parametrization."""',
                    '    assert hello(name) == expected',
                    '',
                ].join('\n'),
            },
        });
    }
}
exports.Pytest = Pytest;
_a = JSII_RTTI_SYMBOL_1;
Pytest[_a] = { fqn: "projen.python.Pytest", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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