"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PoetryPyproject = exports.Poetry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const deps_1 = require("../deps");
const tasks_1 = require("../tasks");
const toml_1 = require("../toml");
const util_1 = require("../util");
/**
 * (experimental) Manage project dependencies, virtual environments, and packaging through the poetry CLI tool.
 *
 * @experimental
 */
class Poetry extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _c;
        super(project);
        this.installTask = project.addTask('install', {
            description: 'Install and upgrade dependencies',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'poetry update',
        });
        this.project.tasks.addEnvironment('VIRTUAL_ENV', '$(poetry env info -p)');
        this.project.tasks.addEnvironment('PATH', '$(echo $(poetry env info -p)/bin:$PATH)');
        // declare the python versions for which the package is compatible
        this.addDependency('python@^3.6');
        this.packageTask = project.addTask('package', {
            description: 'Creates source archive and wheel for distribution.',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'poetry build',
        });
        this.publishTestTask = project.addTask('publish:test', {
            description: 'Uploads the package against a test PyPI endpoint.',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'poetry publish -r testpypi',
        });
        this.publishTask = project.addTask('publish', {
            description: 'Uploads the package to PyPI.',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'poetry publish',
        });
        new PoetryPyproject(project, {
            name: project.name,
            version: options.version,
            description: (_c = options.description) !== null && _c !== void 0 ? _c : '',
            license: options.license,
            authors: [`${options.authorName} <${options.authorEmail}>`],
            homepage: options.homepage,
            classifiers: options.classifiers,
            ...options.poetryOptions,
            dependencies: () => this.synthDependencies(),
            devDependencies: () => this.synthDevDependencies(),
        });
        new toml_1.TomlFile(project, 'poetry.toml', {
            committed: false,
            obj: {
                repositories: {
                    testpypi: {
                        url: 'https://test.pypi.org/legacy/',
                    },
                },
            },
        });
    }
    synthDependencies() {
        const dependencies = {};
        for (const pkg of this.project.deps.all) {
            if (pkg.type === deps_1.DependencyType.RUNTIME) {
                dependencies[pkg.name] = pkg.version;
            }
        }
        return dependencies;
    }
    synthDevDependencies() {
        const dependencies = {};
        for (const pkg of this.project.deps.all) {
            if ([deps_1.DependencyType.DEVENV].includes(pkg.type)) {
                dependencies[pkg.name] = pkg.version;
            }
        }
        return dependencies;
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.RUNTIME);
    }
    /**
     * (experimental) Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDevDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.DEVENV);
    }
    /**
     * (experimental) Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     *
     * @experimental
     */
    setupEnvironment() {
        const result = util_1.execOrUndefined('which poetry', { cwd: this.project.outdir });
        if (!result) {
            this.project.logger.info('Unable to setup an environment since poetry is not installed. Please install poetry (https://python-poetry.org/docs/) or use a different component for managing environments such as \'venv\'.');
        }
        let envPath = util_1.execOrUndefined('poetry env info -p', { cwd: this.project.outdir });
        if (!envPath) {
            this.project.logger.info('Setting up a virtual environment...');
            util_1.exec('poetry env use python', { cwd: this.project.outdir });
            envPath = util_1.execOrUndefined('poetry env info -p', { cwd: this.project.outdir });
            this.project.logger.info(`Environment successfully created (located in ${envPath}}).`);
        }
    }
    /**
     * (experimental) Installs dependencies (called during post-synthesis).
     *
     * @experimental
     */
    installDependencies() {
        this.project.logger.info('Installing dependencies...');
        const runtime = new tasks_1.TaskRuntime(this.project.outdir);
        runtime.runTask(this.installTask.name);
    }
}
exports.Poetry = Poetry;
_a = JSII_RTTI_SYMBOL_1;
Poetry[_a] = { fqn: "projen.python.Poetry", version: "0.23.2" };
/**
 * (experimental) Represents configuration of a pyproject.toml file for a Poetry project.
 *
 * @see https://python-poetry.org/docs/pyproject/
 * @experimental
 */
class PoetryPyproject extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.file = new toml_1.TomlFile(project, 'pyproject.toml', {
            omitEmpty: false,
            obj: {
                'build-system': {
                    'requires': ['poetry_core>=1.0.0'],
                    'build-backend': 'poetry.core.masonry.api',
                },
                'tool': {
                    poetry: {
                        'name': options.name,
                        'version': options.version,
                        'description': options.description,
                        'license': options.license,
                        'authors': options.authors,
                        'maintainers': options.maintainers,
                        'readme': options.readme,
                        'homepage': options.homepage,
                        'repository': options.repository,
                        'documentation': options.documentation,
                        'keywords': options.keywords,
                        'classifiers': options.classifiers,
                        'packages': options.packages,
                        'include': options.include,
                        'exclude': options.exclude,
                        'dependencies': options.dependencies,
                        'dev-dependencies': options.devDependencies,
                        'scripts': options.scripts,
                    },
                },
            },
        });
    }
}
exports.PoetryPyproject = PoetryPyproject;
_b = JSII_RTTI_SYMBOL_1;
PoetryPyproject[_b] = { fqn: "projen.python.PoetryPyproject", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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