"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pip = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const deps_1 = require("../deps");
const tasks_1 = require("../tasks");
const requirements_file_1 = require("./requirements-file");
/**
 * (experimental) Manages dependencies using a requirements.txt file and the pip CLI tool.
 *
 * @experimental
 */
class Pip extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, _options = {}) {
        super(project);
        new requirements_file_1.RequirementsFile(project, 'requirements.txt', { packageProvider: new RuntimeDependencyProvider(project) });
        new requirements_file_1.RequirementsFile(project, 'requirements-dev.txt', { packageProvider: new DevDependencyProvider(project) });
        this.installTask = project.addTask('install', {
            description: 'Install and upgrade dependencies',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.installTask.exec('pip install --upgrade pip');
        this.installTask.exec('pip install -r requirements.txt');
        this.installTask.exec('pip install -r requirements-dev.txt');
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.RUNTIME);
    }
    /**
     * (experimental) Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDevDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.DEVENV);
    }
    /**
     * (experimental) Installs dependencies (called during post-synthesis).
     *
     * @experimental
     */
    installDependencies() {
        this.project.logger.info('Installing dependencies...');
        const runtime = new tasks_1.TaskRuntime(this.project.outdir);
        runtime.runTask(this.installTask.name);
    }
}
exports.Pip = Pip;
_a = JSII_RTTI_SYMBOL_1;
Pip[_a] = { fqn: "projen.python.Pip", version: "0.23.2" };
class RuntimeDependencyProvider {
    constructor(pythonProject) {
        this.pythonProject = pythonProject;
    }
    get packages() {
        return this.pythonProject.deps.all.filter(dep => dep.type === deps_1.DependencyType.RUNTIME);
    }
}
class DevDependencyProvider {
    constructor(pythonProject) {
        this.pythonProject = pythonProject;
    }
    get packages() {
        return this.pythonProject.deps.all.filter(dep => dep.type === deps_1.DependencyType.DEVENV);
    }
}
//# sourceMappingURL=data:application/json;base64,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