"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Publisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const workflows_model_1 = require("./github/workflows-model");
const JSII_RELEASE_VERSION = 'latest';
/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 *
 * Under the hood, it uses https://github.com/aws/jsii-release
 *
 * @experimental
 */
class Publisher extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        // the jobs to add to the release workflow
        this.jobs = {};
        this.buildJobId = options.buildJobId;
        this.artifactName = options.artifactName;
        this.jsiiReleaseVersion = (_b = options.jsiiReleaseVersion) !== null && _b !== void 0 ? _b : JSII_RELEASE_VERSION;
    }
    /**
     * (experimental) Renders a set of workflow jobs for all the publishers.
     *
     * @returns GitHub workflow jobs
     * @experimental
     */
    render() {
        return { ...this.jobs };
    }
    /**
     * (experimental) Publishes artifacts from `js/**` to npm.
     *
     * @param options Options.
     * @experimental
     */
    publishToNpm(options = {}) {
        var _b;
        const npmTokenSecret = (_b = options.npmTokenSecret) !== null && _b !== void 0 ? _b : 'NPM_TOKEN';
        this.jobs.release_npm = {
            permissions: { contents: workflows_model_1.JobPermission.READ },
            name: 'Release to NPM',
            needs: [this.buildJobId],
            runsOn: 'ubuntu-latest',
            container: {
                image: 'jsii/superchain',
            },
            steps: [
                this.renderDownloadArtifactStep(),
                {
                    name: 'Release',
                    run: this.renderJsiiReleaseCommand('jsii-release-npm'),
                    env: {
                        NPM_TOKEN: `\${{ secrets.${npmTokenSecret} }}`,
                        NPM_DIST_TAG: options.distTag,
                        NPM_REGISTRY: options.registry,
                    },
                },
            ],
        };
    }
    /**
     * (experimental) Publishes artifacts from `dotnet/**` to NuGet Gallery.
     *
     * @param options Options.
     * @experimental
     */
    publishToNuget(options = {}) {
        var _b;
        const nugetApiKeySecret = (_b = options.nugetApiKeySecret) !== null && _b !== void 0 ? _b : 'NUGET_API_KEY';
        this.jobs.release_nuget = {
            name: 'Release to Nuget',
            permissions: { contents: workflows_model_1.JobPermission.READ },
            needs: [this.buildJobId],
            runsOn: 'ubuntu-latest',
            container: {
                image: 'jsii/superchain',
            },
            steps: [
                this.renderDownloadArtifactStep(),
                {
                    name: 'Release',
                    run: this.renderJsiiReleaseCommand('jsii-release-nuget'),
                    env: {
                        NUGET_API_KEY: `\${{ secrets.${nugetApiKeySecret} }}`,
                    },
                },
            ],
        };
    }
    /**
     * (experimental) Publishes artifacts from `java/**` to Maven.
     *
     * @param options Options.
     * @experimental
     */
    publishToMaven(options = {}) {
        var _b, _c, _d, _e, _f;
        const mavenGpgPrivateKeySecret = (_b = options.mavenGpgPrivateKeySecret) !== null && _b !== void 0 ? _b : 'MAVEN_GPG_PRIVATE_KEY';
        const mavenGpgPrivateKeyPassphrase = (_c = options.mavenGpgPrivateKeyPassphrase) !== null && _c !== void 0 ? _c : 'MAVEN_GPG_PRIVATE_KEY_PASSPHRASE';
        const mavenUsername = (_d = options.mavenUsername) !== null && _d !== void 0 ? _d : 'MAVEN_USERNAME';
        const mavenPassword = (_e = options.mavenPassword) !== null && _e !== void 0 ? _e : 'MAVEN_PASSWORD';
        const mavenStagingProfileId = (_f = options.mavenStagingProfileId) !== null && _f !== void 0 ? _f : 'MAVEN_STAGING_PROFILE_ID';
        this.jobs.release_maven = {
            name: 'Release to Maven',
            permissions: { contents: workflows_model_1.JobPermission.READ },
            needs: [this.buildJobId],
            runsOn: 'ubuntu-latest',
            container: {
                image: 'jsii/superchain',
            },
            steps: [
                this.renderDownloadArtifactStep(),
                {
                    name: 'Release',
                    run: this.renderJsiiReleaseCommand('jsii-release-maven'),
                    env: {
                        MAVEN_ENDPOINT: options.mavenEndpoint,
                        MAVEN_SERVER_ID: options.mavenServerId,
                        MAVEN_REPOSITORY_URL: options.mavenRepositoryUrl,
                        MAVEN_GPG_PRIVATE_KEY: `\${{ secrets.${mavenGpgPrivateKeySecret} }}`,
                        MAVEN_GPG_PRIVATE_KEY_PASSPHRASE: `\${{ secrets.${mavenGpgPrivateKeyPassphrase} }}`,
                        MAVEN_PASSWORD: `\${{ secrets.${mavenPassword} }}`,
                        MAVEN_USERNAME: `\${{ secrets.${mavenUsername} }}`,
                        MAVEN_STAGING_PROFILE_ID: `\${{ secrets.${mavenStagingProfileId} }}`,
                    },
                },
            ],
        };
    }
    /**
     * (experimental) Publishes wheel artifacts from `python` to PyPI.
     *
     * @param options Options.
     * @experimental
     */
    publishToPyPi(options = {}) {
        var _b, _c;
        const twineUsername = (_b = options.twineUsernameSecret) !== null && _b !== void 0 ? _b : 'TWINE_USERNAME';
        const twinePassword = (_c = options.twinePasswordSecret) !== null && _c !== void 0 ? _c : 'TWINE_PASSWORD';
        this.jobs.release_pypi = {
            name: 'Release to PyPi',
            permissions: { contents: workflows_model_1.JobPermission.READ },
            needs: [this.buildJobId],
            runsOn: 'ubuntu-latest',
            container: {
                image: 'jsii/superchain',
            },
            steps: [
                this.renderDownloadArtifactStep(),
                {
                    name: 'Release',
                    run: this.renderJsiiReleaseCommand('jsii-release-pypi'),
                    env: {
                        TWINE_USERNAME: `\${{ secrets.${twineUsername} }}`,
                        TWINE_PASSWORD: `\${{ secrets.${twinePassword} }}`,
                        ...(options.twineRegistryUrl && { TWINE_REPOSITORY_URL: options.twineRegistryUrl }),
                    },
                },
            ],
        };
    }
    /**
     * (experimental) Adds a go publishing job.
     *
     * @param options Options.
     * @experimental
     */
    publishToGo(options = {}) {
        var _b, _c, _d;
        const githubTokenSecret = (_b = options.githubTokenSecret) !== null && _b !== void 0 ? _b : 'GO_GITHUB_TOKEN';
        this.jobs.release_golang = {
            name: 'Release to Go',
            permissions: { contents: workflows_model_1.JobPermission.READ },
            needs: [this.buildJobId],
            runsOn: 'ubuntu-latest',
            container: {
                image: 'jsii/superchain',
            },
            steps: [
                this.renderDownloadArtifactStep(),
                {
                    name: 'Release',
                    run: this.renderJsiiReleaseCommand('jsii-release-golang'),
                    env: {
                        GITHUB_REPO: options.githubRepo,
                        GITHUB_TOKEN: `\${{ secrets.${githubTokenSecret} }}`,
                        GIT_BRANCH: options.gitBranch,
                        GIT_USER_NAME: (_c = options.gitUserName) !== null && _c !== void 0 ? _c : 'GitHub Actions',
                        GIT_USER_EMAIL: (_d = options.gitUserEmail) !== null && _d !== void 0 ? _d : 'github-actions@github.com',
                        GIT_COMMIT_MESSAGE: options.gitCommitMessage,
                    },
                },
            ],
        };
    }
    renderJsiiReleaseCommand(subcommand) {
        return `npx -p jsii-release@${this.jsiiReleaseVersion} ${subcommand}`;
    }
    renderDownloadArtifactStep() {
        return {
            name: 'Download build artifacts',
            uses: 'actions/download-artifact@v2',
            with: {
                name: this.artifactName,
                path: 'dist',
            },
        };
    }
}
exports.Publisher = Publisher;
_a = JSII_RTTI_SYMBOL_1;
Publisher[_a] = { fqn: "projen.Publisher", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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