"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DependenciesUpgradeMechanism = exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const github_1 = require("./github");
const workflows_model_1 = require("./github/workflows-model");
const ignore_file_1 = require("./ignore-file");
const projenrc_1 = require("./javascript/projenrc");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const release_1 = require("./release");
const tasks_1 = require("./tasks");
const upgrade_dependencies_1 = require("./upgrade-dependencies");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.workflowBootstrapSteps = (_c = options.workflowBootstrapSteps) !== null && _c !== void 0 ? _c : [];
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_d = options.workflowNodeVersion) !== null && _d !== void 0 ? _d : this.package.minNodeVersion;
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
            category: tasks_1.TaskCategory.BUILD,
        });
        // first, execute projen as the first thing during build
        if ((_e = options.projenDuringBuild) !== null && _e !== void 0 ? _e : true) {
            // skip for sub-projects (i.e. "parent" is defined) since synthing the
            // root project will include the subprojects.
            if (!this.parent) {
                this.buildTask.exec(this.projenCommand);
            }
        }
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_f = options.npmignoreEnabled) !== null && _f !== void 0 ? _f : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_g = options.gitignore) === null || _g === void 0 ? void 0 : _g.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_h = options.npmignore) === null || _h === void 0 ? void 0 : _h.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        this.setScript('start', `${this.package.projenCommand} start`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${common_1.PROJEN_RC}`);
        (_k = this.npmignore) === null || _k === void 0 ? void 0 : _k.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_l = options.projenDevDependency) !== null && _l !== void 0 ? _l : true;
        if (projen) {
            const projenVersion = (_m = options.projenVersion) !== null && _m !== void 0 ? _m : `^${common_1.PROJEN_VERSION}`;
            this.addDevDeps(`projen@${projenVersion}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_o = options.buildWorkflow) !== null && _o !== void 0 ? _o : (this.parent ? false : true);
        const mutableBuilds = (_p = options.mutableBuild) !== null && _p !== void 0 ? _p : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_q = options.antitamper) !== null && _q !== void 0 ? _q : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_r = options.jest) !== null && _r !== void 0 ? _r : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_s = options.buildWorkflow) !== null && _s !== void 0 ? _s : (this.parent ? false : true)) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const buildJobId = 'build';
            const updateRepo = new Array();
            const gitDiffStepId = 'git_diff';
            const hasChangesCondName = 'has_changes';
            const hasChanges = `steps.${gitDiffStepId}.outputs.${hasChangesCondName}`;
            const repoFullName = 'github.event.pull_request.head.repo.full_name';
            // use "git diff --exit code" to check if there were changes in the repo
            // and create a step output that will be used in subsequent steps.
            updateRepo.push({
                name: 'Check for changes',
                id: gitDiffStepId,
                run: `git diff --exit-code || echo "::set-output name=${hasChangesCondName}::true"`,
            });
            // only if we had changes, commit them and push to the repo note that for
            // forks, this will fail (because the workflow doesn't have permissions.
            // this indicates to users that they need to update their branch manually.
            updateRepo.push({
                if: hasChanges,
                name: 'Commit and push changes (if changed)',
                run: `git add . && git commit -m "chore: self mutation" && git push origin HEAD:${branch}`,
            });
            // if we pushed changes, we need to manually update the status check so
            // that the PR will be green (we won't get here for forks with updates
            // because the push would have failed).
            updateRepo.push({
                if: hasChanges,
                name: 'Update status check (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/\${{ ${repoFullName} }}/check-runs`,
                    `-F name="${buildJobId}"`,
                    '-F head_sha="$(git rev-parse HEAD)"',
                    '-F status="completed"',
                    '-F conclusion="success"',
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            const workflow = this.createBuildWorkflow('Build', {
                jobId: buildJobId,
                trigger: {
                    pull_request: {},
                },
                permissions: {
                    checks: workflows_model_1.JobPermission.WRITE,
                    contents: workflows_model_1.JobPermission.WRITE,
                },
                checkoutWith: mutableBuilds ? {
                    ref: branch,
                    repository: repo,
                } : undefined,
                postSteps: updateRepo,
                antitamperDisabled: mutableBuilds,
                image: options.workflowContainerImage,
                codeCov: (_t = options.codeCov) !== null && _t !== void 0 ? _t : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
            });
            this.buildWorkflow = workflow;
            this.buildWorkflowJobId = buildJobId;
        }
        const release = (_v = (_u = options.release) !== null && _u !== void 0 ? _u : options.releaseWorkflow) !== null && _v !== void 0 ? _v : (this.parent ? false : true);
        if (release) {
            this.addDevDeps(version_1.Version.STANDARD_VERSION);
            this.release = new release_1.Release(this, {
                versionFile: 'package.json',
                task: this.buildTask,
                branch: (_w = options.defaultReleaseBranch) !== null && _w !== void 0 ? _w : 'main',
                ...options,
                releaseWorkflowSetupSteps: [
                    ...this.installWorkflowSteps,
                    ...(_x = options.releaseWorkflowSetupSteps) !== null && _x !== void 0 ? _x : [],
                ],
            });
            this.publisher = this.release.publisher;
            if ((_y = options.releaseToNpm) !== null && _y !== void 0 ? _y : false) {
                this.release.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_z = this.github) === null || _z === void 0 ? void 0 : _z.mergify) {
            this.autoMerge = new github_1.AutoMerge(this, {
                mergify: (_0 = this.github) === null || _0 === void 0 ? void 0 : _0.mergify,
                buildJob: this.buildWorkflowJobId,
            });
        }
        if (options.dependabot !== undefined && options.depsUpgrade) {
            throw new Error("'dependabot' cannot be configured together with 'depsUpgrade'");
        }
        if (options.projenUpgradeAutoMerge !== undefined && options.autoApproveProjenUpgrades !== undefined) {
            throw new Error("'projenUpgradeAutoMerge' cannot be configured together with 'autoApproveProjenUpgrades'");
        }
        const projenAutoApprove = (_1 = options.autoApproveProjenUpgrades) !== null && _1 !== void 0 ? _1 : ((_2 = options.projenUpgradeAutoMerge) !== null && _2 !== void 0 ? _2 : false);
        const depsAutoApprove = (_3 = options.autoApproveUpgrades) !== null && _3 !== void 0 ? _3 : false;
        if (projenAutoApprove && !this.autoApprove) {
            throw new Error('Autoamtic approval of projen upgrades requires configuring `autoApproveOptions`');
        }
        if (depsAutoApprove && !this.autoApprove) {
            throw new Error('Autoamtic approval of dependencies upgrades requires configuring `autoApproveOptions`');
        }
        const autoApproveLabel = (condition) => { var _c; return (condition && ((_c = this.autoApprove) === null || _c === void 0 ? void 0 : _c.label)) ? [this.autoApprove.label] : undefined; };
        const defaultDependenciesUpgrade = ((_4 = options.dependabot) !== null && _4 !== void 0 ? _4 : false)
            ? DependenciesUpgradeMechanism.dependabot({ labels: autoApproveLabel(depsAutoApprove) })
            : DependenciesUpgradeMechanism.githubWorkflow({
                // if projen secret is defined we can also upgrade projen here.
                ignoreProjen: !options.projenUpgradeSecret,
                workflowOptions: {
                    // if projen secret is defined, use it (otherwise default to GITHUB_TOKEN).
                    secret: options.projenUpgradeSecret,
                    container: options.workflowContainerImage ? {
                        image: options.workflowContainerImage,
                    } : undefined,
                    labels: autoApproveLabel(depsAutoApprove),
                },
            });
        const dependenciesUpgrade = (_5 = options.depsUpgrade) !== null && _5 !== void 0 ? _5 : defaultDependenciesUpgrade;
        dependenciesUpgrade.bind(this);
        if (dependenciesUpgrade.ignoresProjen && this.package.packageName !== 'projen') {
            new upgrade_dependencies_1.UpgradeDependencies(this, {
                include: ['projen'],
                taskName: 'upgrade-projen',
                pullRequestTitle: 'upgrade projen',
                ignoreProjen: false,
                workflow: !!options.projenUpgradeSecret,
                workflowOptions: {
                    schedule: upgrade_dependencies_1.UpgradeDependenciesSchedule.expressions((_6 = options.projenUpgradeSchedule) !== null && _6 !== void 0 ? _6 : ['0 6 * * *']),
                    container: options.workflowContainerImage ? { image: options.workflowContainerImage } : undefined,
                    secret: options.projenUpgradeSecret,
                    labels: autoApproveLabel(projenAutoApprove),
                },
            });
        }
        if ((_7 = options.pullRequestTemplate) !== null && _7 !== void 0 ? _7 : true) {
            (_8 = this.github) === null || _8 === void 0 ? void 0 : _8.addPullRequestTemplate(...(_9 = options.pullRequestTemplateContents) !== null && _9 !== void 0 ? _9 : []);
        }
        const projenrcJs = (_10 = options.projenrcJs) !== null && _10 !== void 0 ? _10 : true;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        // first run the workflow bootstrap steps
        install.push(...this.workflowBootstrapSteps);
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v1',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    /**
     * (experimental) Exclude these files from the bundled package.
     *
     * Implemented by project types based on the
     * packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.
     *
     * @experimental
     */
    addPackageIgnore(pattern) {
        var _c;
        (_c = this.npmignore) === null || _c === void 0 ? void 0 : _c.addPatterns(pattern);
    }
    addLicense(options) {
        var _c;
        if (this.package.license) {
            new license_1.License(this, {
                spdx: this.package.license,
                copyrightOwner: (_c = options.copyrightOwner) !== null && _c !== void 0 ? _c : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    createBuildWorkflow(name, options) {
        var _c, _d, _e, _f, _g;
        const buildJobId = options.jobId;
        const github = this.github;
        if (!github) {
            throw new Error('no github support');
        }
        const workflow = github.addWorkflow(name);
        if (options.trigger) {
            if (options.trigger.issue_comment) {
                throw new Error('"issue_comment" should not be used as a trigger due to a security issue');
            }
            workflow.on(options.trigger);
        }
        workflow.on({
            workflowDispatch: {},
        });
        const condition = options.condition ? { if: options.condition } : {};
        const preBuildSteps = (_c = options.preBuildSteps) !== null && _c !== void 0 ? _c : [];
        const preCheckoutSteps = (_d = options.preCheckoutSteps) !== null && _d !== void 0 ? _d : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const postSteps = (_e = options.postSteps) !== null && _e !== void 0 ? _e : [];
        const antitamperSteps = (options.antitamperDisabled || !this.antitamper) ? [] : [{
                name: 'Anti-tamper check',
                run: 'git diff --ignore-space-at-eol --exit-code',
            }];
        const job = {
            runsOn: 'ubuntu-latest',
            env: {
                CI: 'true',
                ...(_f = options.env) !== null && _f !== void 0 ? _f : {},
            },
            permissions: options.permissions,
            ...condition,
            steps: [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // install dependencies
                ...this.installWorkflowSteps,
                // perform an anti-tamper check immediately after we run projen.
                ...antitamperSteps,
                // sets git identity so we can push later
                {
                    name: 'Set git identity',
                    run: [
                        'git config user.name "Automation"',
                        'git config user.email "github-actions@github.com"',
                    ].join('\n'),
                },
                // if there are changes, creates a bump commit
                ...preBuildSteps,
                // build (compile + test)
                {
                    name: 'Build',
                    run: this.runTaskCommand(this.buildTask),
                },
                // run codecov if enabled or a secret token name is passed in
                // AND jest must be configured
                ...(options.codeCov || options.codeCovTokenSecret) && ((_g = this.jest) === null || _g === void 0 ? void 0 : _g.config) ? [{
                        name: 'Upload coverage to Codecov',
                        uses: 'codecov/codecov-action@v1',
                        with: options.codeCovTokenSecret ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        } : {
                            directory: this.jest.config.coverageDirectory,
                        },
                    }] : [],
                ...postSteps,
                // anti-tamper check (fails if there were changes to committed files)
                // this will identify any non-committed files generated during build (e.g. test snapshots)
                ...antitamperSteps,
            ],
        };
        if (options.image) {
            job.container = { image: options.image };
        }
        workflow.addJobs({ [buildJobId]: job });
        return workflow;
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * If
     * npmTaskExecution is set to PROJEN, the command will be `npx projen TASK`.
     * If it is set to SHELL, the command will be `yarn run TASK` (or `npm run
     * TASK`).
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        return `${this.package.projenCommand} ${task.name}`;
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.23.2" };
/**
 * (experimental) Dependencies upgrade mechanism.
 *
 * @experimental
 */
class DependenciesUpgradeMechanism {
    constructor(binder, _ignoresProjen) {
        this.binder = binder;
        this._ignoresProjen = _ignoresProjen;
    }
    /**
     * (experimental) Upgrade via dependabot.
     *
     * @experimental
     */
    static dependabot(options = {}) {
        return new DependenciesUpgradeMechanism((project) => {
            var _c;
            (_c = project.github) === null || _c === void 0 ? void 0 : _c.addDependabot(options);
        }, options.ignoreProjen);
    }
    /**
     * (experimental) Upgrade via a custom github workflow.
     *
     * @experimental
     */
    static githubWorkflow(options = {}) {
        return new DependenciesUpgradeMechanism((project) => {
            new upgrade_dependencies_1.UpgradeDependencies(project, options);
        }, options.ignoreProjen);
    }
    /**
     * @experimental
     */
    get ignoresProjen() {
        var _c;
        // we ignore projen by default because it requires 'workflow' permissions to run.
        // nor depenedabot nor the default github token has those permissions.
        return (_c = this._ignoresProjen) !== null && _c !== void 0 ? _c : true;
    }
    /**
     * @experimental
     */
    bind(project) {
        this.binder(project);
    }
}
exports.DependenciesUpgradeMechanism = DependenciesUpgradeMechanism;
_b = JSII_RTTI_SYMBOL_1;
DependenciesUpgradeMechanism[_b] = { fqn: "projen.DependenciesUpgradeMechanism", version: "0.23.2" };
/**
 * (experimental) Disable.
 *
 * @experimental
 */
DependenciesUpgradeMechanism.NONE = new DependenciesUpgradeMechanism((_) => ({}), true);
//# sourceMappingURL=data:application/json;base64,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