"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiProject = exports.Stability = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const jsii_docgen_1 = require("./jsii-docgen");
const tasks_1 = require("./tasks");
const typescript_1 = require("./typescript");
const DEFAULT_JSII_IMAGE = 'jsii/superchain';
const EMAIL_REGEX = /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/;
const URL_REGEX = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[\-;:&=\+\$,\w]+@)?[A-Za-z0-9\.\-]+|(?:www\.|[\-;:&=\+\$,\w]+@)[A-Za-z0-9\.\-]+)((?:\/[\+~%\/\.\w\-_]*)?\??(?:[\-\+=&;%@\.\w_]*)#?(?:[\.\!\/\\\w]*))?)/;
/**
 * @experimental
 */
var Stability;
(function (Stability) {
    Stability["EXPERIMENTAL"] = "experimental";
    Stability["STABLE"] = "stable";
    Stability["DEPRECATED"] = "deprecated";
})(Stability = exports.Stability || (exports.Stability = {}));
/**
 * (experimental) Multi-language jsii library project.
 *
 * @experimental
 */
class JsiiProject extends typescript_1.TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const { authorEmail, authorUrl } = parseAuthorAddress(options);
        super({
            ...options,
            workflowContainerImage: (_b = options.workflowContainerImage) !== null && _b !== void 0 ? _b : DEFAULT_JSII_IMAGE,
            // this is needed temporarily because our release workflows use the 'gh'
            // cli and its not yet available in jsii/superchain
            releaseWorkflowSetupSteps: options.releaseWorkflowSetupSteps,
            releaseToNpm: false,
            repository: options.repositoryUrl,
            authorName: options.author,
            ...options,
            disableTsconfig: true,
            authorEmail,
            authorUrl,
        });
        const srcdir = this.srcdir;
        const libdir = this.libdir;
        this.addFields({ types: `${libdir}/index.d.ts` });
        // this is an unhelpful warning
        const jsiiFlags = [
            '--silence-warnings=reserved-word',
            '--no-fix-peer-dependencies',
        ].join(' ');
        const compatIgnore = (_c = options.compatIgnore) !== null && _c !== void 0 ? _c : '.compatignore';
        this.addFields({ stability: (_d = options.stability) !== null && _d !== void 0 ? _d : Stability.STABLE });
        if (options.stability === Stability.DEPRECATED) {
            this.addFields({ deprecated: true });
        }
        const compatTask = this.addTask('compat', {
            description: 'Perform API compatibility check against latest version',
            category: tasks_1.TaskCategory.RELEASE,
            exec: `jsii-diff npm:$(node -p "require(\'./package.json\').name") -k --ignore-file ${compatIgnore} || (echo "\nUNEXPECTED BREAKING CHANGES: add keys such as \'removed:constructs.Node.of\' to ${compatIgnore} to skip.\n" && exit 1)`,
        });
        const compat = (_e = options.compat) !== null && _e !== void 0 ? _e : false;
        if (compat) {
            this.compileTask.spawn(compatTask);
        }
        this.compileTask.reset(`jsii ${jsiiFlags}`);
        this.watchTask.reset(`jsii -w ${jsiiFlags}`);
        (_f = this.packageTask) === null || _f === void 0 ? void 0 : _f.reset('jsii-pacmak');
        const targets = {};
        const jsii = {
            outdir: 'dist',
            targets,
            tsc: {
                outDir: libdir,
                rootDir: srcdir,
            },
        };
        if (options.excludeTypescript) {
            jsii.excludeTypescript = options.excludeTypescript;
        }
        this.addFields({ jsii });
        if (options.releaseToNpm != false) {
            (_g = this.publisher) === null || _g === void 0 ? void 0 : _g.publishToNpm({
                distTag: this.package.npmDistTag,
                registry: this.package.npmRegistry,
                npmTokenSecret: this.package.npmTokenSecret,
            });
        }
        // we cannot call an option `java` because the java code generated by jsii
        // does not compile due to a conflict between this option name and the `java`
        // package (e.g. when `java.util.Objects` is referenced).
        if ('java' in options) {
            throw new Error('the "java" option is now called "publishToMaven"');
        }
        if (options.publishToMaven) {
            targets.java = {
                package: options.publishToMaven.javaPackage,
                maven: {
                    groupId: options.publishToMaven.mavenGroupId,
                    artifactId: options.publishToMaven.mavenArtifactId,
                },
            };
            (_h = this.publisher) === null || _h === void 0 ? void 0 : _h.publishToMaven(options.publishToMaven);
        }
        const pypi = (_j = options.publishToPypi) !== null && _j !== void 0 ? _j : options.python;
        if (pypi) {
            targets.python = {
                distName: pypi.distName,
                module: pypi.module,
            };
            (_k = this.publisher) === null || _k === void 0 ? void 0 : _k.publishToPyPi(pypi);
        }
        const nuget = (_l = options.publishToNuget) !== null && _l !== void 0 ? _l : options.dotnet;
        if (nuget) {
            targets.dotnet = {
                namespace: nuget.dotNetNamespace,
                packageId: nuget.packageId,
            };
            (_m = this.publisher) === null || _m === void 0 ? void 0 : _m.publishToNuget(nuget);
        }
        const golang = options.publishToGo;
        if (golang) {
            targets.go = {
                moduleName: golang.moduleName,
            };
            (_o = this.publisher) === null || _o === void 0 ? void 0 : _o.publishToGo(golang);
        }
        this.addDevDeps('jsii', 'jsii-diff', 'jsii-pacmak');
        this.gitignore.exclude('.jsii', 'tsconfig.json');
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.include('.jsii');
        if ((_q = options.docgen) !== null && _q !== void 0 ? _q : true) {
            new jsii_docgen_1.JsiiDocgen(this);
        }
        // jsii updates .npmignore, so we make it writable
        if (this.npmignore) {
            this.npmignore.readonly = false;
        }
    }
}
exports.JsiiProject = JsiiProject;
_a = JSII_RTTI_SYMBOL_1;
JsiiProject[_a] = { fqn: "projen.JsiiProject", version: "0.23.2" };
function parseAuthorAddress(options) {
    let authorEmail = options.authorEmail;
    let authorUrl = options.authorUrl;
    if (options.authorAddress) {
        if (options.authorEmail && options.authorEmail !== options.authorAddress) {
            throw new Error('authorEmail is deprecated and cannot be used in conjunction with authorAddress');
        }
        if (options.authorUrl && options.authorUrl !== options.authorAddress) {
            throw new Error('authorUrl is deprecated and cannot be used in conjunction with authorAddress.');
        }
        if (EMAIL_REGEX.test(options.authorAddress)) {
            authorEmail = options.authorAddress;
        }
        else if (URL_REGEX.test(options.authorAddress)) {
            authorUrl = options.authorAddress;
        }
        else {
            throw new Error(`authorAddress must be either an email address or a URL: ${options.authorAddress}`);
        }
    }
    return { authorEmail, authorUrl };
}
//# sourceMappingURL=data:application/json;base64,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