"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const ini_1 = require("../ini");
/**
 * (experimental) File representing the local NPM config in .npmrc.
 *
 * @experimental
 */
class NpmConfig extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        super(project);
        /**
         * The config object. This object can be mutated until the project is
         * synthesized.
         */
        this.config = {};
        new ini_1.IniFile(project, '.npmrc', { obj: this.config });
        if (options.registry) {
            this.addRegistry(options.registry);
        }
    }
    /**
     * (experimental) configure a scoped registry.
     *
     * @param url the URL of the registry to use.
     * @param scope the scope the registry is used for;
     * @experimental
     */
    addRegistry(url, scope) {
        this.addConfig(scope ? `${scope}:registry` : 'registry', url);
    }
    /**
     * (experimental) configure a generic property.
     *
     * @param name the name of the property.
     * @param value the value of the property.
     * @experimental
     */
    addConfig(name, value) {
        this.config[name] = value;
    }
}
exports.NpmConfig = NpmConfig;
_a = JSII_RTTI_SYMBOL_1;
NpmConfig[_a] = { fqn: "projen.javascript.NpmConfig", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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