"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenCompile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const tasks_1 = require("../tasks");
/**
 * (experimental) Adds the maven-compiler plugin to a POM file and the `compile` task.
 *
 * @experimental
 */
class MavenCompile extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, pom, options = {}) {
        var _b, _c;
        super(project);
        project.gitignore.exclude('target');
        pom.addPlugin('org.apache.maven.plugins/maven-compiler-plugin@3.8.1', {
            configuration: {
                source: (_b = options.source) !== null && _b !== void 0 ? _b : '1.8',
                target: (_c = options.target) !== null && _c !== void 0 ? _c : '1.8',
            },
        });
        this.compileTask = project.addTask('compile', {
            description: 'Compile the main source files',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'mvn compiler:compile',
        });
    }
}
exports.MavenCompile = MavenCompile;
_a = JSII_RTTI_SYMBOL_1;
MavenCompile[_a] = { fqn: "projen.java.MavenCompile", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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