import { Component } from '../component';
import { Project } from '../project';
import { Dependabot, DependabotOptions } from './dependabot';
import { Mergify } from './mergify';
import { PullRequestTemplate } from './pr-template';
import { GithubWorkflow } from './workflows';
/**
 * @experimental
 */
export interface GitHubOptions {
    /**
     * (experimental) Whether mergify should be enabled on this repository or not.
     *
     * @default true
     * @experimental
     */
    readonly mergify?: boolean;
}
/**
 * @experimental
 */
export declare class GitHub extends Component {
    /**
     * (experimental) The `Mergify` configured on this repository.
     *
     * This is `undefined` if Mergify
     * was not enabled when creating the repository.
     *
     * @experimental
     */
    readonly mergify?: Mergify;
    /**
     * @experimental
     */
    constructor(project: Project, options?: GitHubOptions);
    /**
     * @experimental
     */
    addWorkflow(name: string): GithubWorkflow;
    /**
     * @experimental
     */
    addPullRequestTemplate(...content: string[]): PullRequestTemplate;
    /**
     * @experimental
     */
    addDependabot(options?: DependabotOptions): Dependabot;
}
