"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoMerge = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * (experimental) Sets up mergify to merging approved pull requests.
 *
 * If `buildJob` is specified, the specified GitHub workflow job ID is required
 * to succeed in order for the PR to be merged.
 *
 * `approvedReviews` specified the number of code review approvals required for
 * the PR to be merged.
 *
 * @experimental
 */
class AutoMerge extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        const mergify = options.mergify;
        const successfulBuild = options.buildJob
            ? [`status-success=${options.buildJob}`]
            : [];
        const mergeAction = {
            merge: {
                // squash all commits into a single commit when merging
                method: 'squash',
                // use PR title+body as the commit message
                commit_message: 'title+body',
                // update PR branch so it's up-to-date before merging
                strict: 'smart',
                strict_method: 'merge',
            },
            delete_head_branch: {},
        };
        const approvedReviews = (_b = options.approvedReviews) !== null && _b !== void 0 ? _b : 1;
        mergify.addRule({
            name: 'Automatic merge on approval and successful build',
            actions: mergeAction,
            conditions: [
                `#approved-reviews-by>=${approvedReviews}`,
                ...successfulBuild,
            ],
        });
        this.project.addPackageIgnore('/.mergify.yml');
    }
}
exports.AutoMerge = AutoMerge;
_a = JSII_RTTI_SYMBOL_1;
AutoMerge[_a] = { fqn: "projen.github.AutoMerge", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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