"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoApprove = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const workflows_1 = require("./workflows");
const workflows_model_1 = require("./workflows-model");
/**
 * (experimental) Auto approve pull requests that meet a criteria.
 *
 * @experimental
 */
class AutoApprove extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b, _c;
        super(project);
        this.label = (_b = options.label) !== null && _b !== void 0 ? _b : 'auto-approve';
        const usernames = (_c = options.allowedUsernames) !== null && _c !== void 0 ? _c : ['github-actions[bot]'];
        if (!project.github) {
            throw new Error('auto approval supported only for Github projects');
        }
        let condition = `contains(github.event.pull_request.labels.*.name, '${this.label}')`;
        if (usernames.length > 0) {
            condition += ' && (';
            condition += usernames.map(u => `github.event.pull_request.user.login == '${u}'`).join(' || ');
            condition += ')';
        }
        const approveJob = {
            runsOn: 'ubuntu-latest',
            permissions: {
                pullRequests: workflows_model_1.JobPermission.WRITE,
            },
            if: condition,
            steps: [{
                    uses: 'hmarr/auto-approve-action@v2.1.0',
                    with: {
                        'github-token': `\${{ secrets.${options.secret} }}`,
                    },
                }],
        };
        const workflow = new workflows_1.GithubWorkflow(project.github, 'auto-approve');
        workflow.on({
            // The 'pull request' event gives the workflow 'read-only' permissions on some
            // pull requests (such as the ones from dependabot) when using the `GITHUB_TOKEN`
            // security token. This prevents the workflow from approving these pull requests.
            // Github has placed this guard so as to prevent security attacks by simply opening
            // a pull request and triggering a workflow on a commit that was not vetted to make
            // unintended changes to the repository.
            //
            // Instead use the 'pull request target' event here that gives the Github workflow
            // 'read-write' permissions. This is safe because, this event, unlike the 'pull request'
            // event references the BASE commit of the pull request and not the HEAD commit.
            pullRequestTarget: {
                types: ['labeled', 'opened', 'synchronize', 'reopened', 'ready_for_review'],
            },
        });
        workflow.addJobs({ approve: approveJob });
    }
}
exports.AutoApprove = AutoApprove;
_a = JSII_RTTI_SYMBOL_1;
AutoApprove[_a] = { fqn: "projen.github.AutoApprove", version: "0.23.2" };
//# sourceMappingURL=data:application/json;base64,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