"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const _resolve_1 = require("./_resolve");
const common_1 = require("./common");
const component_1 = require("./component");
const util_1 = require("./util");
/**
 * @experimental
 */
class FileBase extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        var _b, _c, _d, _e, _f;
        super(project);
        if (((_b = options.committed) !== null && _b !== void 0 ? _b : true) && filePath !== '.gitattributes') {
            project.root.annotateGenerated(`/${filePath}`);
        }
        this.readonly = (_c = options.readonly) !== null && _c !== void 0 ? _c : true;
        this.executable = (_d = options.executable) !== null && _d !== void 0 ? _d : false;
        this.path = filePath;
        this.absolutePath = path.resolve(project.outdir, filePath);
        // verify file path is unique within project tree
        const existing = project.root.tryFindFile(this.absolutePath);
        if (existing && existing !== this) {
            throw new Error(`there is already a file under ${path.relative(project.root.outdir, this.absolutePath)}`);
        }
        const gitignore = (_e = options.editGitignore) !== null && _e !== void 0 ? _e : true;
        if (gitignore) {
            const committed = (_f = options.committed) !== null && _f !== void 0 ? _f : true;
            const pattern = `/${this.path}`;
            if (committed) {
                project.gitignore.include(pattern);
            }
            else {
                project.gitignore.exclude(pattern);
            }
        }
        else {
            if (options.committed != null) {
                throw new Error('"gitignore" is disabled, so it does not make sense to specify "committed"');
            }
        }
    }
    /**
     * (experimental) Writes the file to the project's output directory.
     *
     * @experimental
     */
    synthesize() {
        const outdir = this.project.outdir;
        const filePath = path.join(outdir, this.path);
        const resolver = { resolve: (obj, options) => _resolve_1.resolve(obj, options) };
        const content = this.synthesizeContent(resolver);
        if (content === undefined) {
            return; // skip
        }
        util_1.writeFile(filePath, content, {
            readonly: this.readonly,
            executable: this.executable,
        });
    }
}
exports.FileBase = FileBase;
_a = JSII_RTTI_SYMBOL_1;
FileBase[_a] = { fqn: "projen.FileBase", version: "0.23.2" };
/**
 * (experimental) The marker to embed in files in order to identify them as projen files.
 *
 * This marker is used to prune these files before synthesis.
 *
 * @experimental
 */
FileBase.PROJEN_MARKER = `${common_1.PROJEN_MARKER}. To modify, edit ${common_1.PROJEN_RC} and run "npx projen".`;
//# sourceMappingURL=data:application/json;base64,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