"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const yargs = require("yargs");
const common_1 = require("../common");
const tasks_1 = require("../tasks");
const synth_1 = require("./synth");
const tasks_2 = require("./tasks");
const DEFAULT_RC = path_1.resolve(common_1.PROJEN_RC);
async function main() {
    const ya = yargs;
    ya.commandDir('cmds');
    const runtime = new tasks_1.TaskRuntime('.');
    tasks_2.discoverTaskCommands(runtime, ya);
    ya.recommendCommands();
    ya.strictCommands();
    ya.wrap(yargs.terminalWidth());
    ya.option('post', { type: 'boolean', default: true, desc: 'Run post-synthesis steps such as installing dependencies. Use --no-post to skip' });
    ya.option('watch', { type: 'boolean', default: false, desc: 'Keep running and resynthesize when projenrc changes', alias: 'w' });
    ya.options('debug', { type: 'boolean', default: false, desc: 'Debug logs' });
    ya.options('rc', { desc: 'path to .projenrc.js file', default: DEFAULT_RC, type: 'string' });
    ya.completion();
    ya.help();
    // do not use the default yargs '--version' implementation since it is
    // global by default (it appears on all subcommands)
    ya.version(false);
    ya.option('version', { type: 'boolean', description: 'Show version number', global: false });
    const args = ya.argv;
    if (args.debug) {
        process.env.DEBUG = 'true';
    }
    // no command means synthesize
    if (args._.length === 0) {
        if (args.version) {
            console.log(common_1.PROJEN_VERSION);
            process.exit(0);
        }
        await synth_1.synth(runtime, {
            post: args.post,
            watch: args.watch,
            rcfile: args.rc,
        });
    }
}
main().catch(e => {
    console.error(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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