"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tasks_1 = require("../../tasks");
const start_app_1 = require("./start-app");
class Command {
    constructor() {
        this.command = 'start';
        this.describe = 'Prints all project commands';
    }
    builder(args) {
        return args.option('interactive', { type: 'boolean', alias: 'i', desc: 'Interactive menu', default: true });
    }
    async handler(opts) {
        const tasks = new tasks_1.TaskRuntime(process.cwd());
        if (opts.interactive) {
            await start_app_1.showStartMenu(tasks);
        }
        else {
            start_app_1.printStartMenu(tasks);
        }
    }
}
module.exports = new Command();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhcnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvY2xpL2NtZHMvc3RhcnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFDQSx1Q0FBMEM7QUFDMUMsMkNBQTREO0FBRTVELE1BQU0sT0FBTztJQUFiO1FBQ0UsWUFBTyxHQUFHLE9BQU8sQ0FBQztRQUNsQixhQUFRLEdBQUcsNkJBQTZCLENBQUM7SUFjM0MsQ0FBQztJQVpRLE9BQU8sQ0FBQyxJQUFnQjtRQUM3QixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxFQUFFLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLElBQUksRUFBRSxrQkFBa0IsRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUM5RyxDQUFDO0lBRUQsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFTO1FBQ3JCLE1BQU0sS0FBSyxHQUFHLElBQUksbUJBQVcsQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUM3QyxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDcEIsTUFBTSx5QkFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQzVCO2FBQU07WUFDTCwwQkFBYyxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQ3ZCO0lBQ0gsQ0FBQztDQUNGO0FBRUQsTUFBTSxDQUFDLE9BQU8sR0FBRyxJQUFJLE9BQU8sRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgeWFyZ3MgZnJvbSAneWFyZ3MnO1xuaW1wb3J0IHsgVGFza1J1bnRpbWUgfSBmcm9tICcuLi8uLi90YXNrcyc7XG5pbXBvcnQgeyBwcmludFN0YXJ0TWVudSwgc2hvd1N0YXJ0TWVudSB9IGZyb20gJy4vc3RhcnQtYXBwJztcblxuY2xhc3MgQ29tbWFuZCBpbXBsZW1lbnRzIHlhcmdzLkNvbW1hbmRNb2R1bGUge1xuICBjb21tYW5kID0gJ3N0YXJ0JztcbiAgZGVzY3JpYmUgPSAnUHJpbnRzIGFsbCBwcm9qZWN0IGNvbW1hbmRzJztcblxuICBwdWJsaWMgYnVpbGRlcihhcmdzOiB5YXJncy5Bcmd2KSB7XG4gICAgcmV0dXJuIGFyZ3Mub3B0aW9uKCdpbnRlcmFjdGl2ZScsIHsgdHlwZTogJ2Jvb2xlYW4nLCBhbGlhczogJ2knLCBkZXNjOiAnSW50ZXJhY3RpdmUgbWVudScsIGRlZmF1bHQ6IHRydWUgfSk7XG4gIH1cblxuICBhc3luYyBoYW5kbGVyKG9wdHM6IGFueSkge1xuICAgIGNvbnN0IHRhc2tzID0gbmV3IFRhc2tSdW50aW1lKHByb2Nlc3MuY3dkKCkpO1xuICAgIGlmIChvcHRzLmludGVyYWN0aXZlKSB7XG4gICAgICBhd2FpdCBzaG93U3RhcnRNZW51KHRhc2tzKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcHJpbnRTdGFydE1lbnUodGFza3MpO1xuICAgIH1cbiAgfVxufVxuXG5tb2R1bGUuZXhwb3J0cyA9IG5ldyBDb21tYW5kKCk7Il19