"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const web_1 = require("../../web");
const util_1 = require("../util");
test('defaults', () => {
    const p = new TestReactTypeScriptProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
class TestReactTypeScriptProject extends web_1.ReactTypeScriptProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-nextjs-project',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'main',
            projenVersion: '^1.2.3',
        });
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVhY3QtdHMtcHJvamVjdC50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL19fdGVzdHNfXy93ZWIvcmVhY3QtdHMtcHJvamVjdC50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEseUNBQXdDO0FBQ3hDLG1DQUFrRjtBQUNsRixrQ0FBaUQ7QUFFakQsSUFBSSxDQUFDLFVBQVUsRUFBRSxHQUFHLEVBQUU7SUFDcEIsTUFBTSxDQUFDLEdBQUcsSUFBSSwwQkFBMEIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxvQkFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZUFBZSxFQUFFLENBQUM7QUFDN0MsQ0FBQyxDQUFDLENBQUM7QUFFSCxNQUFNLDBCQUEyQixTQUFRLDRCQUFzQjtJQUM3RCxZQUFZLFVBQWtELEVBQUc7UUFDL0QsS0FBSyxDQUFDO1lBQ0osR0FBRyxPQUFPO1lBQ1YsT0FBTyxFQUFFLEtBQUs7WUFDZCxJQUFJLEVBQUUscUJBQXFCO1lBQzNCLE1BQU0sRUFBRSxjQUFPLEVBQUU7WUFDakIsT0FBTyxFQUFFLEVBQUUsS0FBSyxFQUFFLGlCQUFRLENBQUMsR0FBRyxFQUFFO1lBQ2hDLG9CQUFvQixFQUFFLE1BQU07WUFDNUIsYUFBYSxFQUFFLFFBQVE7U0FDeEIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgTG9nTGV2ZWwgfSBmcm9tICcuLi8uLi9sb2dnZXInO1xuaW1wb3J0IHsgUmVhY3RUeXBlU2NyaXB0UHJvamVjdCwgUmVhY3RUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMgfSBmcm9tICcuLi8uLi93ZWInO1xuaW1wb3J0IHsgbWtkdGVtcCwgc3ludGhTbmFwc2hvdCB9IGZyb20gJy4uL3V0aWwnO1xuXG50ZXN0KCdkZWZhdWx0cycsICgpID0+IHtcbiAgY29uc3QgcCA9IG5ldyBUZXN0UmVhY3RUeXBlU2NyaXB0UHJvamVjdCgpO1xuICBleHBlY3Qoc3ludGhTbmFwc2hvdChwKSkudG9NYXRjaFNuYXBzaG90KCk7XG59KTtcblxuY2xhc3MgVGVzdFJlYWN0VHlwZVNjcmlwdFByb2plY3QgZXh0ZW5kcyBSZWFjdFR5cGVTY3JpcHRQcm9qZWN0IHtcbiAgY29uc3RydWN0b3Iob3B0aW9uczogUGFydGlhbDxSZWFjdFR5cGVTY3JpcHRQcm9qZWN0T3B0aW9ucz4gPSB7IH0pIHtcbiAgICBzdXBlcih7XG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgY2xvYmJlcjogZmFsc2UsXG4gICAgICBuYW1lOiAndGVzdC1uZXh0anMtcHJvamVjdCcsXG4gICAgICBvdXRkaXI6IG1rZHRlbXAoKSxcbiAgICAgIGxvZ2dpbmc6IHsgbGV2ZWw6IExvZ0xldmVsLk9GRiB9LFxuICAgICAgZGVmYXVsdFJlbGVhc2VCcmFuY2g6ICdtYWluJyxcbiAgICAgIHByb2plblZlcnNpb246ICdeMS4yLjMnLFxuICAgIH0pO1xuICB9XG59XG4iXX0=