"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const web_1 = require("../../web");
const util_1 = require("../util");
test('defaults', () => {
    const p = new TestNextJsTypeScriptProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('tailwind enabled', () => {
    const p = new TestNextJsTypeScriptProject();
    const out = util_1.synthSnapshot(p);
    expect(out['tailwind.config.json']).toBeDefined();
    expect(out['postcss.config.json']).toBeDefined();
});
class TestNextJsTypeScriptProject extends web_1.NextJsTypeScriptProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-nextjs-project',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'main',
            projenVersion: '^1.2.3',
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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