"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const web_1 = require("../../web");
const util_1 = require("../util");
test('defaults', () => {
    const p = new TestNextJsProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('tailwind enabled', () => {
    const p = new TestNextJsProject();
    const pkg = util_1.synthSnapshot(p);
    expect(pkg['tailwind.config.json']).toBeDefined();
    expect(pkg['postcss.config.json']).toBeDefined();
});
class TestNextJsProject extends web_1.NextJsProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-nextjs-project',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'main',
            projenVersion: '^1.2.3',
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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