"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const file_1 = require("../file");
const launch_config_1 = require("../vscode/launch-config");
const util_1 = require("./util");
const VSCODE_DEBUGGER_FILE = '.vscode/launch.json';
test('empty launch configuration', () => {
    var _a;
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    (_a = project.vscode) === null || _a === void 0 ? void 0 : _a.launchConfiguration;
    // THEN
    expect(util_1.synthSnapshot(project)[VSCODE_DEBUGGER_FILE]).toStrictEqual({
        '//': file_1.FileBase.PROJEN_MARKER,
        'version': '0.2.0',
        'configurations': [],
    });
});
test('adding a launch configuration entry', () => {
    var _a;
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    const launchConfig = (_a = project.vscode) === null || _a === void 0 ? void 0 : _a.launchConfiguration;
    launchConfig === null || launchConfig === void 0 ? void 0 : launchConfig.addConfiguration({
        type: 'node',
        request: 'launch',
        name: 'CDK Debugger',
        skipFiles: ['<node_internals>/**'],
        runtimeArgs: ['-r', './node_modules/ts-node/register/transpile-only'],
        args: ['${workspaceFolder}/src/main.ts'],
    });
    // THEN
    expect(util_1.synthSnapshot(project)[VSCODE_DEBUGGER_FILE]).toStrictEqual({
        '//': file_1.FileBase.PROJEN_MARKER,
        'version': '0.2.0',
        'configurations': [
            {
                type: 'node',
                request: 'launch',
                name: 'CDK Debugger',
                skipFiles: ['<node_internals>/**'],
                runtimeArgs: ['-r', './node_modules/ts-node/register/transpile-only'],
                args: ['${workspaceFolder}/src/main.ts'],
            },
        ],
    });
});
test('adding multiple launch configuration entries', () => {
    var _a;
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    const launchConfig = (_a = project.vscode) === null || _a === void 0 ? void 0 : _a.launchConfiguration;
    launchConfig === null || launchConfig === void 0 ? void 0 : launchConfig.addConfiguration({
        type: 'node',
        request: 'launch',
        name: 'CDK Debugger',
        skipFiles: ['<node_internals>/**'],
        runtimeArgs: ['-r', './node_modules/ts-node/register/transpile-only'],
        args: ['${workspaceFolder}/src/main.ts'],
    });
    launchConfig === null || launchConfig === void 0 ? void 0 : launchConfig.addConfiguration({
        type: 'node',
        request: 'launch',
        name: 'Launch Program',
        skipFiles: ['<node_internals>/**'],
        program: '${workspaceFolder}/lib/index.js',
        preLaunchTask: 'tsc: build - tsconfig.json',
        outFiles: ['${workspaceFolder}/lib/**/*.js'],
        internalConsoleOptions: launch_config_1.InternalConsoleOptions.OPEN_ON_SESSION_START,
    });
    launchConfig === null || launchConfig === void 0 ? void 0 : launchConfig.addConfiguration({
        type: 'pwa-chrome',
        request: 'launch',
        name: 'Launch Chrome against localhost',
        url: 'http://localhost:8080',
        webRoot: '${workspaceFolder}',
        debugServer: 4711,
    });
    // THEN
    expect(util_1.synthSnapshot(project)[VSCODE_DEBUGGER_FILE]).toStrictEqual({
        '//': file_1.FileBase.PROJEN_MARKER,
        'version': '0.2.0',
        'configurations': [
            {
                type: 'node',
                request: 'launch',
                name: 'CDK Debugger',
                skipFiles: ['<node_internals>/**'],
                runtimeArgs: ['-r', './node_modules/ts-node/register/transpile-only'],
                args: ['${workspaceFolder}/src/main.ts'],
            },
            {
                type: 'node',
                request: 'launch',
                name: 'Launch Program',
                skipFiles: ['<node_internals>/**'],
                program: '${workspaceFolder}/lib/index.js',
                preLaunchTask: 'tsc: build - tsconfig.json',
                outFiles: ['${workspaceFolder}/lib/**/*.js'],
                internalConsoleOptions: 'openOnSessionStart',
            },
            {
                type: 'pwa-chrome',
                request: 'launch',
                name: 'Launch Chrome against localhost',
                url: 'http://localhost:8080',
                webRoot: '${workspaceFolder}',
                debugServer: 4711,
            },
        ],
    });
});
//# sourceMappingURL=data:application/json;base64,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