"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const __1 = require("..");
const util_1 = require("./util");
test('file paths are relative to the project outdir', () => {
    // GIVEN
    const p = new util_1.TestProject();
    // WHEN
    const f = new __1.TextFile(p, 'foo/bar.txt');
    // THEN
    expect(f.absolutePath).toBe(path.resolve(p.outdir, f.path));
    expect(path.isAbsolute(f.absolutePath)).toBeTruthy();
});
test('all files added to the project can be enumerated', () => {
    // GIVEN
    const p = new util_1.TestProject();
    new __1.TextFile(p, 'my.txt');
    new __1.JsonFile(p, 'your/file/me.json', { obj: {} });
    // WHEN
    const result = p.files;
    // THEN
    const exp = (e) => expect(result.map(x => x.path).includes(e)).toBeTruthy();
    exp('my.txt');
    exp('your/file/me.json');
});
test('findFile() can be used to find a file either absolute or relative path', () => {
    // GIVEN
    const p = new util_1.TestProject();
    const file = new __1.JsonFile(p, 'your/file/me.json', { obj: {} });
    // WHEN
    const result1 = p.tryFindFile('your/file/me.json');
    const result2 = p.tryFindFile(path.resolve(p.outdir, 'your/file/me.json'));
    // THEN
    expect(result1 === file).toBeTruthy();
    expect(result2 === file).toBeTruthy();
});
test('findFile() will also look up files in subprojects', () => {
    // GIVEN
    const p = new util_1.TestProject();
    const child = new __1.Project({ name: 'foobar', parent: p, outdir: 'subproject/foo/bar' });
    const fchild = new __1.TextFile(child, 'fchild.txt');
    // WHEN
    const result1 = p.tryFindFile('subproject/foo/bar/fchild.txt');
    const result2 = child.tryFindFile('fchild.txt');
    // THEN
    expect(result1 === fchild).toBeTruthy();
    expect(result2 === fchild).toBeTruthy();
});
test('autoApprove is configured', () => {
    var _a;
    // WHEN
    const p = new util_1.TestProject({
        autoApproveOptions: {
            secret: 'MY_SECRET',
        },
    });
    // THEN
    expect(p.autoApprove).toBeDefined();
    expect((_a = p.autoApprove) === null || _a === void 0 ? void 0 : _a.label).toEqual('auto-approve');
});
//# sourceMappingURL=data:application/json;base64,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