"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const github_1 = require("../github");
const util_1 = require("./util");
const PULL_REQUEST_TEMPLATE_FILE = '.github/pull_request_template.md';
test('default', () => {
    // GIVEN
    const project = new util_1.TestProject();
    const github = new github_1.GitHub(project);
    // WHEN
    github.addPullRequestTemplate();
    // THEN
    expect(util_1.synthSnapshot(project)[PULL_REQUEST_TEMPLATE_FILE]).toStrictEqual('Fixes #');
});
test('custom content', () => {
    // GIVEN
    const project = new util_1.TestProject();
    const github = new github_1.GitHub(project);
    // WHEN
    github.addPullRequestTemplate('hello', 'world', '', 'foobar');
    // THEN
    expect(util_1.synthSnapshot(project)[PULL_REQUEST_TEMPLATE_FILE]).toStrictEqual([
        'hello',
        'world',
        '',
        'foobar',
    ].join('\n'));
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHItdGVtcGxhdGUudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9fX3Rlc3RzX18vcHItdGVtcGxhdGUudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHNDQUFtQztBQUNuQyxpQ0FBb0Q7QUFFcEQsTUFBTSwwQkFBMEIsR0FBRyxrQ0FBa0MsQ0FBQztBQUV0RSxJQUFJLENBQUMsU0FBUyxFQUFFLEdBQUcsRUFBRTtJQUNuQixRQUFRO0lBQ1IsTUFBTSxPQUFPLEdBQUcsSUFBSSxrQkFBVyxFQUFFLENBQUM7SUFDbEMsTUFBTSxNQUFNLEdBQUcsSUFBSSxlQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7SUFFbkMsT0FBTztJQUNQLE1BQU0sQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO0lBRWhDLE9BQU87SUFDUCxNQUFNLENBQUMsb0JBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBQ3RGLENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLGdCQUFnQixFQUFFLEdBQUcsRUFBRTtJQUMxQixRQUFRO0lBQ1IsTUFBTSxPQUFPLEdBQUcsSUFBSSxrQkFBVyxFQUFFLENBQUM7SUFDbEMsTUFBTSxNQUFNLEdBQUcsSUFBSSxlQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7SUFFbkMsT0FBTztJQUNQLE1BQU0sQ0FBQyxzQkFBc0IsQ0FDM0IsT0FBTyxFQUNQLE9BQU8sRUFDUCxFQUFFLEVBQ0YsUUFBUSxDQUNULENBQUM7SUFFRixPQUFPO0lBQ1AsTUFBTSxDQUFDLG9CQUFhLENBQUMsT0FBTyxDQUFDLENBQUMsMEJBQTBCLENBQUMsQ0FBQyxDQUFDLGFBQWEsQ0FBQztRQUN2RSxPQUFPO1FBQ1AsT0FBTztRQUNQLEVBQUU7UUFDRixRQUFRO0tBQ1QsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztBQUNoQixDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdpdEh1YiB9IGZyb20gJy4uL2dpdGh1Yic7XG5pbXBvcnQgeyBzeW50aFNuYXBzaG90LCBUZXN0UHJvamVjdCB9IGZyb20gJy4vdXRpbCc7XG5cbmNvbnN0IFBVTExfUkVRVUVTVF9URU1QTEFURV9GSUxFID0gJy5naXRodWIvcHVsbF9yZXF1ZXN0X3RlbXBsYXRlLm1kJztcblxudGVzdCgnZGVmYXVsdCcsICgpID0+IHtcbiAgLy8gR0lWRU5cbiAgY29uc3QgcHJvamVjdCA9IG5ldyBUZXN0UHJvamVjdCgpO1xuICBjb25zdCBnaXRodWIgPSBuZXcgR2l0SHViKHByb2plY3QpO1xuXG4gIC8vIFdIRU5cbiAgZ2l0aHViLmFkZFB1bGxSZXF1ZXN0VGVtcGxhdGUoKTtcblxuICAvLyBUSEVOXG4gIGV4cGVjdChzeW50aFNuYXBzaG90KHByb2plY3QpW1BVTExfUkVRVUVTVF9URU1QTEFURV9GSUxFXSkudG9TdHJpY3RFcXVhbCgnRml4ZXMgIycpO1xufSk7XG5cbnRlc3QoJ2N1c3RvbSBjb250ZW50JywgKCkgPT4ge1xuICAvLyBHSVZFTlxuICBjb25zdCBwcm9qZWN0ID0gbmV3IFRlc3RQcm9qZWN0KCk7XG4gIGNvbnN0IGdpdGh1YiA9IG5ldyBHaXRIdWIocHJvamVjdCk7XG5cbiAgLy8gV0hFTlxuICBnaXRodWIuYWRkUHVsbFJlcXVlc3RUZW1wbGF0ZShcbiAgICAnaGVsbG8nLFxuICAgICd3b3JsZCcsXG4gICAgJycsXG4gICAgJ2Zvb2JhcicsXG4gICk7XG5cbiAgLy8gVEhFTlxuICBleHBlY3Qoc3ludGhTbmFwc2hvdChwcm9qZWN0KVtQVUxMX1JFUVVFU1RfVEVNUExBVEVfRklMRV0pLnRvU3RyaWN0RXF1YWwoW1xuICAgICdoZWxsbycsXG4gICAgJ3dvcmxkJyxcbiAgICAnJyxcbiAgICAnZm9vYmFyJyxcbiAgXS5qb2luKCdcXG4nKSk7XG59KTtcbiJdfQ==