"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const INI = require("ini");
const __1 = require("..");
const util_1 = require("./util");
test('ini object can be mutated before synthesis', () => {
    const prj = new util_1.TestProject();
    const obj = {
        hello: 'world',
    };
    new __1.IniFile(prj, 'my/ini/file.ini', { obj, marker: false });
    // mutate obj (should be reflected in the output)
    obj.anotherField = {
        foo: 1234,
    };
    const out = util_1.synthSnapshot(prj);
    expect(INI.parse(out['my/ini/file.ini'])).toMatchObject({
        hello: 'world',
        anotherField: { foo: '1234' },
    });
});
test('ini file can contain projen marker', () => {
    const prj = new util_1.TestProject();
    const obj = {};
    new __1.IniFile(prj, 'my/ini/file-marker.ini', { obj, marker: true });
    const output = util_1.synthSnapshot(prj)['my/ini/file-marker.ini'];
    const firstLine = output.split('\n')[0];
    expect(firstLine).toBe(`# ${__1.IniFile.PROJEN_MARKER}`);
});
//# sourceMappingURL=data:application/json;base64,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