"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const auto_approve_1 = require("../../github/auto-approve");
const node_project_1 = require("../../node-project");
const util_1 = require("../util");
describe('auto-approve', () => {
    test('default', () => {
        const project = createProject();
        new auto_approve_1.AutoApprove(project, {
            secret: 'MY_SECRET',
        });
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/workflows/auto-approve.yml']).toBeDefined();
        expect(snapshot['.github/workflows/auto-approve.yml']).toMatchSnapshot();
    });
    test('configure options', () => {
        const project = createProject();
        new auto_approve_1.AutoApprove(project, {
            secret: 'MY_SECRET',
            label: 'my-approve',
            allowedUsernames: ['bot-1', 'bot-2'],
        });
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/workflows/auto-approve.yml']).toMatchSnapshot();
    });
    test('all users', () => {
        const project = createProject();
        new auto_approve_1.AutoApprove(project, {
            secret: 'MY_SECRET',
            allowedUsernames: [],
        });
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/workflows/auto-approve.yml']).toMatchSnapshot();
    });
});
function createProject(options = {}) {
    return new node_project_1.NodeProject({
        outdir: util_1.mkdtemp(),
        defaultReleaseBranch: 'main',
        name: 'node-project',
        ...options,
    });
}
//# sourceMappingURL=data:application/json;base64,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