"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdktf_construct_1 = require("../cdktf-construct");
const logger_1 = require("../logger");
const node_package_1 = require("../node-package");
const util_1 = require("./util");
describe('constructs dependency selection', () => {
    test('user-selected', () => {
        var _a, _b, _c, _d, _e, _f;
        // GIVEN
        const project = new TestProject({ cdktfVersion: '0.99' });
        // WHEN
        const snapshot = util_1.synthSnapshot(project);
        // THEN
        expect((_b = (_a = snapshot['package.json']) === null || _a === void 0 ? void 0 : _a.peerDependencies) === null || _b === void 0 ? void 0 : _b.cdktf).toBe('^0.99');
        expect((_d = (_c = snapshot['package.json']) === null || _c === void 0 ? void 0 : _c.devDependencies) === null || _d === void 0 ? void 0 : _d.cdktf).toBe('0.99.0');
        expect((_f = (_e = snapshot['package.json']) === null || _e === void 0 ? void 0 : _e.dependencies) === null || _f === void 0 ? void 0 : _f.cdktf).toBeUndefined();
    });
});
const defaultOptions = {
    author: 'Nobody',
    authorAddress: 'nobody@nowhere.com',
    clobber: false,
    defaultReleaseBranch: 'main',
    jest: false,
    name: 'test-project',
    npmAccess: node_package_1.NpmAccess.PUBLIC,
    repositoryUrl: 'https://github.com/projen/projen.git',
};
class TestProject extends cdktf_construct_1.ConstructLibraryCdktf {
    constructor(options) {
        super({
            outdir: util_1.mkdtemp(),
            logging: {
                level: logger_1.LogLevel.OFF,
            },
            ...defaultOptions,
            ...options,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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