# Generated by Django 3.2.6 on 2022-04-22 18:48

from django.conf import settings
from django.db import migrations, models, connection
import django.db.models.deletion


def check_table_name_exists(table_name):
    """
    Проверка наличия таблицы в БД по ее названию
    """
    table_exists = False
    with connection.cursor() as cursor:
        cursor.execute(
            "SELECT "
            " table_name "
            "FROM information_schema.tables "
            "WHERE "
            "  table_name='{}'".format(table_name)
        )
        table_exists = bool(cursor.cursor.rowcount)

    return table_exists


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]
    if not check_table_name_exists('creadoc_report'):
        operations = [
            migrations.CreateModel(
                name='CreadocReport',
                fields=[
                    ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                    ('guid', models.CharField(max_length=128, unique=True, verbose_name='Уникальный идентификатор шаблона')),
                    ('name', models.CharField(max_length=128, verbose_name='Наименование шаблона')),
                    ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Дата и время создания записи')),
                    ('changed_at', models.DateTimeField(auto_now=True, verbose_name='Дата и время последнего изменения')),
                    ('state', models.BooleanField(default=True, verbose_name='Статус шаблона')),
                    ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Автор шаблона')),
                ],
                options={
                    'verbose_name': 'Шаблон отчетной формы',
                    'verbose_name_plural': 'Шаблоны отчетных форм',
                    'db_table': 'creadoc_report',
                },
            ),
            migrations.CreateModel(
                name='CreadocReportDataSource',
                fields=[
                    ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                    ('source_uid', models.CharField(max_length=128, verbose_name='Идентификатор источника данных')),
                    ('report', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='creadoc.creadocreport', verbose_name='Отчетная форма')),
                ],
                options={
                    'verbose_name': 'Подключенный источник данных',
                    'verbose_name_plural': 'Подключенные источники данных',
                    'db_table': 'creadoc_report_data_source',
                },
            ),
        ]
