Project flashcam
================

`FLASk supported Http webCAM`

*IN DEVELOPMENT*

Here, the merge of several ideas forms the easy installable (via pip)
webcam server. The basic goal is to

-   view various technical devices during an experiment and
-   have some tools to get more from the stream

Technical
=========

-   the camera is launched from *web.py* function *frames()*, where

*Camera()* class (defined in *real~camerra~.py*) is first called.

-   IDpath is recommended over vendor:model ... *-p 14.0-usb-0:5:1.0*

-   I use the lossless YUYV for camera readout in the *real~camera~.py*.
-   The quality of jpg stream in defined in *web.py* *gen()* option *-k*
    -   default was 95% ( eg. 99% / 25% )
    -   for resolution 1k: 105kB/frame (230kB/20kB)
    -   for res 640: 46kB/frame ( 100kB/ 8.5kB )
        -   (70% 15kB, 80% 20kB, 90% 30kB, 100% 129kB)
    -   finaly : `70%` is already readable and small
        -   100% works too (astro)

Uninteraplible client (uni node)
--------------------------------

The server attaches time (and frame?) stamp at the end of the data. When
this client sees it, it displays that and - when tracking - it writes to
the file.

This client can replay video (and use the tools). Video can be paused
with SPACE.

Usage remarks
=============

Videodevice/image/screen
------------------------

It searches for the 1st video device and recommends it to the class.

If *-p* is used, usb videodevice is selected.

If or *-p filename.jpg* is given, file is streamed (searches in
\~/.config/flashcam/).

If *-p screenshot.jpg* is given, *pyautogui* is used to take a
screenshot and broadcast.

Use cases
=========

Usage screen
------------

``` {.bash org-language="sh"}
... usage:
    flashcam ls
    flashcam getres [product | IDpath ]        # flashcam getres "Webcam C270"
    flashcam show ... show
    flashcam show  "Webcam C270"  -r 320x176

    flashcam flask & # (just a hint for gunicorn+wget)
    flashcam flask5000 [-w]   #  view on port 5000, immediatelly start browser tab

    flashcam savecfg [-a 11 ...]  # save cmdline parameters to congig for flask/gunicorn

..... advanced usage .... (accumulation, blur, threshold, frame_kind)
    flashcam show -a 19 -b 3 -t 100 -f [direct|delta|detect|histo]  [-h]  [-l 3600]

....  v4l setting .......... (exposure, gain  for automatically recommended video)
    flashcam v4l -e [auto | 0.0..1.0]  -g [0.0..1.0]

...... uninteruptable stream .....................
    flashcam uni http://192.168.0.91:8000/video  [-s ] # to save avi

```

Typical usecases
----------------

### Broadcast the sceen

actualy, if `screenshot.jpg` doesnt exist, current screen will be
broadcasted

``` {.bash org-language="sh"}
flahscam flask5000 -w -p screenshot.jpg
```

### motion

*-t* parameter with threshold value triggers *detect motion* mode

``` {.bash org-language="sh"}
# tune parameters with flask5000 or show; no parameter == default value
# -w means - open web view
flashcam.py flask5000  -w -l 1 -a 11 -b 11 -t 30
# save config
flashcam.py savecfg -l 1 -a 11 -b 11 -t 50
# run server - ONE worker, many threads
#    option flask should start wget with delay to start the camera
flashcam.py flask& gunicorn --threads 5  -w 1 -b 0.0.0.0:8000  --timeout 15 web:app
```

### astro

### Repair avi file

*not properly done*

``` {.bash org-language="sh"}
#  x:- is compensate to right y:- is compensate to down;   -x -0.35  -y -0.015
# repair broken AVI
ls -1 *avi | xargs -n 1 -I III ffmpeg -i III -c:v copy -c:a copy repIII
```

### Join many avi files from UNI

*not properly done*

``` {.bash org-language="sh"}
ls zen_192.168.0.91_* | while read line; do echo file \'$line\'; done | ffmpeg -protocol_whitelist file,pipe -f concat -i - -c copy output.avi

```

Status:
-------

-   `usbcheck` can identify the camera by `product` or `IDpath`
-   `v4l2` prove of concept - exposure/gain autotune - worked
-   `show` (imshow) was tuned, now it needs a rewrite with `base_camera`
-   `flask` interface is responsive
-   `web.py` must be same with `flask5000` option
-   `base_camera` (with greenlets) and `real_camera` modules work with
    flask
    -   initialized with `recommend`
    -   never-stopping (unlike the original version)
    -   more tricky tuning classmethod andstaticmethod was needed
-   `flask` interface works
-   gray frame is sent when no camera through web
-   autostarts (threading) with `wget -u -p -O /dev/null` for 3 sec. and
    then kill
-   properly taken `product` in `real_cam`
-   rewrite proprerly for gunicorn (no gevent; --w 1 --t 5+); flashcam
    flask
-   with automatic wget to start, with debugprint for gunicorn too
-   !! `product` may not work now
-   `stream_enhancer` decorations ON
-   =detect motion basics ON -t threshold (0 - means NO)
-   three modes -a 10 -b 3 -t 100 -f \[direct\|delta\|detect\]
-   v4l commandline and in-image display works
-   astro delta x,y per second works
-   saving to \$HOME path
-   `uni` option ... uninteruptable view, \'s\' to save \'q\' to quit,
    -s to save avi

To see next
-----------

-   automatic exposure
-   save jpg from web

V4l2
----

Camera sometimes needs to tune at dark conditions. Nicely done project
to call `v4l2-ctrl` was used

Identification of a camera
--------------------------

Several devices on USB, replugging or an built-in webcam of the notebok
or sevral dev/video devices per CAM can make identification via
`/dev/video` more difficult.

Connection SEREAD/FLASHCAM/NOTIFATOR
====================================

Since:

-   it is possible to control camera image by mmap
    -   example being `seread` looking at ports 8100,8099 (udp,tcp)
-   camera can report to `telegram` (via notifator)

**It** is possible to chain all and report to `telegram` like following:

**1. Prepare Notifator**

`~/.telegram.token` should contain the TOKEN and CHATID (same for all
your bots) It may look like this:

``` {.bash org-language="sh"}
[ALERT]
token=1479238749:ASnFKSJHaUGgFKBFASKUYGbjhahbefBBJSE
chatid=394972397

```

More bots possible in the same file.

**2. Start seread**

``` {.bash org-language="sh"}
# create socket on background
socat PTY,link=/tmp/virtser_connect,raw,echo=0 PTY,link=/tmp/virtser_speak,raw,echo=0&
# initialize it
echo ahoj > /tmp/virtser_speak
# launch server with this fake socket
# -s means - open 8099 and 8100 servers
./bin_seread -D /tmp/virtser_connect -s
```

**3. Start flashcam with DM**

``` {.bash org-language="sh"}
# like this, DETECTION-MOTION MUST be enabled (-t)
# in version 1.0.35
#  imageZMQ MUST be enabled too (the address) - to check -
./bin_flashcam.py flask5000 -t 50 -a 3 -b 3 -f detect -i 127.0.0.1

```

**4. Change screens, send telegrams**

``` {.bash org-language="sh"}
echo "influxmebeam nfs 1 BEAM_ON_ 1 1 123"     | nc -u 127.0.0.1 8100
echo "influxmebeam nfs 1 DET_RDY__ 1 1 123"    | nc -u 127.0.0.1 8100
echo "influxmebeam nfs 1 DET_RDY_ 1 1 123"     | nc -u 127.0.0.1 8100
echo "influxmebeam nfs 1 DET_NRDY 1 1 123"     | nc -u 127.0.0.1 8100
echo "influxmebeam nfs START_RUN_N1_P2_dasqwe" | nc -u 127.0.0.1 8100
echo "influxmebeam nfs 1 DET_RDY_ 1 1 123"     | nc -u 127.0.0.1 8100
echo "influxmebeam nfs STOP_RUN time"          | nc -u 127.0.0.1 8100
```

WARNINGS
========

pip3 install jinja2==2.11.2

ntb doesnt respond the same shift-c and gigajm

1114081-2-3-4 on gigajm b001-b100 OK

65505 6556 in zen BAD
