import PySimpleGUI as sg

from cblaster.gui.parts import TextLabel, TEXT_WIDTH


sg.theme("Lightgrey1")


gne_frame = sg.Frame(
    "Gene neighbourhood plot",
    layout=[
        [sg.Text(
            "This workflow will allow you to plot the effect of increasing the "
            "intergenic distance threshold on the size and amount of detected "
            "hit clusters. This is helpful mainly as a sanity check, to ensure "
            "you are not missing clusters due to a bad threshold value. However, "
            "it can also give you an idea of the approximate size of the "
            "'neighbourhood' of your query proteins.",
            size=(TEXT_WIDTH, 7)
        )],
        [TextLabel("Session file"),
         sg.InputText(size=(34, 1), key="session gne"),
         sg.FileBrowse(key="session gne")],
        [sg.Text(
            "A session file (.json) generated by a cblaster search.",
            size=(TEXT_WIDTH, 1)
        )],
        [TextLabel("Output file"),
         sg.InputText(key="output gne", size=(34, 1)),
         sg.FileSaveAs(key="output gne")],
        [sg.Text(
            "Output file for the summary table.",
            size=(TEXT_WIDTH, 1)
        )],

        [TextLabel("Delimiter"),
         sg.InputText(key="delimiter gne", size=(34, 1))],
        [sg.Text(
            "Character used to delimit values in the summary table. If no delimiter"
            " is specified, the table will be generated in human-readable format.",
            size=(TEXT_WIDTH, 2)
        )],

        [TextLabel("Hide headers"), sg.Checkbox("", key="hide headers gne")],
        [sg.Text(
            "Hide all headers in the summary table. This includes organism and scaffold"
            " headers, as well as headers in the hit table.",
            size=(TEXT_WIDTH, 2)
        )],

        [TextLabel("Decimal places"),
         sg.Spin(
             list(range(6)),
             initial_value=2,
             key="decimals gne"
         )],

        [TextLabel("Plot"),
         sg.InputText(key="plot gne", size=(34, 1)),
         sg.FileSaveAs(key="plot gne")],
        [sg.Text(
            "File path to save the plot HTML file too. This will combine all the "
            "necessary parts to generate a fully usable static HTML file. If this"
            " is not specified, the plot will be saved in a plot.html in the "
            "temporary folder.",
            size=(TEXT_WIDTH, 3)
        )],

        [TextLabel("Max. intergenic distance"),
         sg.InputText(default_text="100000", key="max_gap")],
        [TextLabel("Number of samples"),
         sg.InputText(default_text="100", key="samples")],
        [TextLabel("Sampling space"),
         sg.Drop(values=["linear", "log"], key="scale")],
    ],
    title_color="blue",
    font="Arial 10 bold",
    relief="flat",
)

layout = [[gne_frame]]
