# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulpcore.configuration import Configuration


class Artifact(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'file': 'file',
        'size': 'int',
        'md5': 'str',
        'sha1': 'str',
        'sha224': 'str',
        'sha256': 'str',
        'sha384': 'str',
        'sha512': 'str'
    }

    attribute_map = {
        'file': 'file',
        'size': 'size',
        'md5': 'md5',
        'sha1': 'sha1',
        'sha224': 'sha224',
        'sha256': 'sha256',
        'sha384': 'sha384',
        'sha512': 'sha512'
    }

    def __init__(self, file=None, size=None, md5=None, sha1=None, sha224=None, sha256=None, sha384=None, sha512=None, local_vars_configuration=None):  # noqa: E501
        """Artifact - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._file = None
        self._size = None
        self._md5 = None
        self._sha1 = None
        self._sha224 = None
        self._sha256 = None
        self._sha384 = None
        self._sha512 = None
        self.discriminator = None

        self.file = file
        if size is not None:
            self.size = size
        self.md5 = md5
        self.sha1 = sha1
        self.sha224 = sha224
        self.sha256 = sha256
        self.sha384 = sha384
        self.sha512 = sha512

    @property
    def file(self):
        """Gets the file of this Artifact.  # noqa: E501

        The stored file.  # noqa: E501

        :return: The file of this Artifact.  # noqa: E501
        :rtype: file
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this Artifact.

        The stored file.  # noqa: E501

        :param file: The file of this Artifact.  # noqa: E501
        :type: file
        """
        if self.local_vars_configuration.client_side_validation and file is None:  # noqa: E501
            raise ValueError("Invalid value for `file`, must not be `None`")  # noqa: E501

        self._file = file

    @property
    def size(self):
        """Gets the size of this Artifact.  # noqa: E501

        The size of the file in bytes.  # noqa: E501

        :return: The size of this Artifact.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Artifact.

        The size of the file in bytes.  # noqa: E501

        :param size: The size of this Artifact.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def md5(self):
        """Gets the md5 of this Artifact.  # noqa: E501

        The MD5 checksum of the file if available.  # noqa: E501

        :return: The md5 of this Artifact.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this Artifact.

        The MD5 checksum of the file if available.  # noqa: E501

        :param md5: The md5 of this Artifact.  # noqa: E501
        :type: str
        """

        self._md5 = md5

    @property
    def sha1(self):
        """Gets the sha1 of this Artifact.  # noqa: E501

        The SHA-1 checksum of the file if available.  # noqa: E501

        :return: The sha1 of this Artifact.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this Artifact.

        The SHA-1 checksum of the file if available.  # noqa: E501

        :param sha1: The sha1 of this Artifact.  # noqa: E501
        :type: str
        """

        self._sha1 = sha1

    @property
    def sha224(self):
        """Gets the sha224 of this Artifact.  # noqa: E501

        The SHA-224 checksum of the file if available.  # noqa: E501

        :return: The sha224 of this Artifact.  # noqa: E501
        :rtype: str
        """
        return self._sha224

    @sha224.setter
    def sha224(self, sha224):
        """Sets the sha224 of this Artifact.

        The SHA-224 checksum of the file if available.  # noqa: E501

        :param sha224: The sha224 of this Artifact.  # noqa: E501
        :type: str
        """

        self._sha224 = sha224

    @property
    def sha256(self):
        """Gets the sha256 of this Artifact.  # noqa: E501

        The SHA-256 checksum of the file if available.  # noqa: E501

        :return: The sha256 of this Artifact.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this Artifact.

        The SHA-256 checksum of the file if available.  # noqa: E501

        :param sha256: The sha256 of this Artifact.  # noqa: E501
        :type: str
        """

        self._sha256 = sha256

    @property
    def sha384(self):
        """Gets the sha384 of this Artifact.  # noqa: E501

        The SHA-384 checksum of the file if available.  # noqa: E501

        :return: The sha384 of this Artifact.  # noqa: E501
        :rtype: str
        """
        return self._sha384

    @sha384.setter
    def sha384(self, sha384):
        """Sets the sha384 of this Artifact.

        The SHA-384 checksum of the file if available.  # noqa: E501

        :param sha384: The sha384 of this Artifact.  # noqa: E501
        :type: str
        """

        self._sha384 = sha384

    @property
    def sha512(self):
        """Gets the sha512 of this Artifact.  # noqa: E501

        The SHA-512 checksum of the file if available.  # noqa: E501

        :return: The sha512 of this Artifact.  # noqa: E501
        :rtype: str
        """
        return self._sha512

    @sha512.setter
    def sha512(self, sha512):
        """Sets the sha512 of this Artifact.

        The SHA-512 checksum of the file if available.  # noqa: E501

        :param sha512: The sha512 of this Artifact.  # noqa: E501
        :type: str
        """

        self._sha512 = sha512

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Artifact):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Artifact):
            return True

        return self.to_dict() != other.to_dict()
