# pulpcore-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 3.14.6
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulpcore
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulpcore
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulpcore
from pulpcore.client.pulpcore.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulpcore.Configuration(
    host = "http://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulpcore.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulpcore.Configuration(
    host = "http://pulp",
    api_key = {
        'Session': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Session'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulpcore.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulpcore.AccessPoliciesApi(api_client)
    customized = True # bool |  (optional)
limit = 56 # int | Number of results to return per page. (optional)
offset = 56 # int | The initial index from which to return the results. (optional)
ordering = 'ordering_example' # str | Which field to use when ordering the results. (optional)
viewset_name = 'viewset_name_example' # str | Filter results where viewset_name matches value (optional)
viewset_name__contains = 'viewset_name__contains_example' # str | Filter results where viewset_name contains value (optional)
viewset_name__icontains = 'viewset_name__icontains_example' # str | Filter results where viewset_name contains value (optional)
viewset_name__in = ['viewset_name__in_example'] # list[str] | Filter results where viewset_name is in a comma-separated list of values (optional)
viewset_name__startswith = 'viewset_name__startswith_example' # str | Filter results where viewset_name starts with value (optional)
fields = 'fields_example' # str | A list of fields to include in the response. (optional)
exclude_fields = 'exclude_fields_example' # str | A list of fields to exclude from the response. (optional)

    try:
        # List access policys
        api_response = api_instance.list(customized=customized, limit=limit, offset=offset, ordering=ordering, viewset_name=viewset_name, viewset_name__contains=viewset_name__contains, viewset_name__icontains=viewset_name__icontains, viewset_name__in=viewset_name__in, viewset_name__startswith=viewset_name__startswith, fields=fields, exclude_fields=exclude_fields)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccessPoliciesApi->list: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessPoliciesApi* | [**list**](docs/AccessPoliciesApi.md#list) | **GET** /pulp/api/v3/access_policies/ | List access policys
*AccessPoliciesApi* | [**partial_update**](docs/AccessPoliciesApi.md#partial_update) | **PATCH** {access_policy_href} | Update an access policy
*AccessPoliciesApi* | [**read**](docs/AccessPoliciesApi.md#read) | **GET** {access_policy_href} | Inspect an access policy
*AccessPoliciesApi* | [**update**](docs/AccessPoliciesApi.md#update) | **PUT** {access_policy_href} | Update an access policy
*ArtifactsApi* | [**create**](docs/ArtifactsApi.md#create) | **POST** /pulp/api/v3/artifacts/ | Create an artifact
*ArtifactsApi* | [**delete**](docs/ArtifactsApi.md#delete) | **DELETE** {artifact_href} | Delete an artifact
*ArtifactsApi* | [**list**](docs/ArtifactsApi.md#list) | **GET** /pulp/api/v3/artifacts/ | List artifacts
*ArtifactsApi* | [**read**](docs/ArtifactsApi.md#read) | **GET** {artifact_href} | Inspect an artifact
*ContentApi* | [**list**](docs/ContentApi.md#list) | **GET** /pulp/api/v3/content/ | List content
*ContentguardsApi* | [**list**](docs/ContentguardsApi.md#list) | **GET** /pulp/api/v3/contentguards/ | List content guards
*ExportersPulpApi* | [**create**](docs/ExportersPulpApi.md#create) | **POST** /pulp/api/v3/exporters/core/pulp/ | Create a pulp exporter
*ExportersPulpApi* | [**delete**](docs/ExportersPulpApi.md#delete) | **DELETE** {pulp_exporter_href} | Delete a pulp exporter
*ExportersPulpApi* | [**list**](docs/ExportersPulpApi.md#list) | **GET** /pulp/api/v3/exporters/core/pulp/ | List pulp exporters
*ExportersPulpApi* | [**partial_update**](docs/ExportersPulpApi.md#partial_update) | **PATCH** {pulp_exporter_href} | Update a pulp exporter
*ExportersPulpApi* | [**read**](docs/ExportersPulpApi.md#read) | **GET** {pulp_exporter_href} | Inspect a pulp exporter
*ExportersPulpApi* | [**update**](docs/ExportersPulpApi.md#update) | **PUT** {pulp_exporter_href} | Update a pulp exporter
*ExportersPulpExportsApi* | [**create**](docs/ExportersPulpExportsApi.md#create) | **POST** {pulp_exporter_href}exports/ | Create a pulp export
*ExportersPulpExportsApi* | [**delete**](docs/ExportersPulpExportsApi.md#delete) | **DELETE** {pulp_pulp_export_href} | Delete a pulp export
*ExportersPulpExportsApi* | [**list**](docs/ExportersPulpExportsApi.md#list) | **GET** {pulp_exporter_href}exports/ | List pulp exports
*ExportersPulpExportsApi* | [**read**](docs/ExportersPulpExportsApi.md#read) | **GET** {pulp_pulp_export_href} | Inspect a pulp export
*GroupsApi* | [**create**](docs/GroupsApi.md#create) | **POST** /pulp/api/v3/groups/ | Create a group
*GroupsApi* | [**delete**](docs/GroupsApi.md#delete) | **DELETE** {auth_group_href} | Delete a group
*GroupsApi* | [**list**](docs/GroupsApi.md#list) | **GET** /pulp/api/v3/groups/ | List groups
*GroupsApi* | [**partial_update**](docs/GroupsApi.md#partial_update) | **PATCH** {auth_group_href} | Update a group
*GroupsApi* | [**read**](docs/GroupsApi.md#read) | **GET** {auth_group_href} | Inspect a group
*GroupsApi* | [**update**](docs/GroupsApi.md#update) | **PUT** {auth_group_href} | Update a group
*GroupsModelPermissionsApi* | [**create**](docs/GroupsModelPermissionsApi.md#create) | **POST** {auth_group_href}model_permissions/ | Create a permission
*GroupsModelPermissionsApi* | [**delete**](docs/GroupsModelPermissionsApi.md#delete) | **DELETE** {auth_groups_model_permission_href} | Delete a permission
*GroupsModelPermissionsApi* | [**list**](docs/GroupsModelPermissionsApi.md#list) | **GET** {auth_group_href}model_permissions/ | List permissions
*GroupsModelPermissionsApi* | [**read**](docs/GroupsModelPermissionsApi.md#read) | **GET** {auth_groups_model_permission_href} | Inspect a permission
*GroupsObjectPermissionsApi* | [**create**](docs/GroupsObjectPermissionsApi.md#create) | **POST** {auth_group_href}object_permissions/ | Create a permission
*GroupsObjectPermissionsApi* | [**delete**](docs/GroupsObjectPermissionsApi.md#delete) | **DELETE** {auth_groups_object_permission_href} | Delete a permission
*GroupsObjectPermissionsApi* | [**list**](docs/GroupsObjectPermissionsApi.md#list) | **GET** {auth_group_href}object_permissions/ | List permissions
*GroupsObjectPermissionsApi* | [**read**](docs/GroupsObjectPermissionsApi.md#read) | **GET** {auth_groups_object_permission_href} | Inspect a permission
*GroupsUsersApi* | [**create**](docs/GroupsUsersApi.md#create) | **POST** {auth_group_href}users/ | Create an user
*GroupsUsersApi* | [**delete**](docs/GroupsUsersApi.md#delete) | **DELETE** {auth_groups_user_href} | Delete an user
*GroupsUsersApi* | [**list**](docs/GroupsUsersApi.md#list) | **GET** {auth_group_href}users/ | List users
*ImportersPulpApi* | [**create**](docs/ImportersPulpApi.md#create) | **POST** /pulp/api/v3/importers/core/pulp/ | Create a pulp importer
*ImportersPulpApi* | [**delete**](docs/ImportersPulpApi.md#delete) | **DELETE** {pulp_importer_href} | Delete a pulp importer
*ImportersPulpApi* | [**list**](docs/ImportersPulpApi.md#list) | **GET** /pulp/api/v3/importers/core/pulp/ | List pulp importers
*ImportersPulpApi* | [**partial_update**](docs/ImportersPulpApi.md#partial_update) | **PATCH** {pulp_importer_href} | Update a pulp importer
*ImportersPulpApi* | [**read**](docs/ImportersPulpApi.md#read) | **GET** {pulp_importer_href} | Inspect a pulp importer
*ImportersPulpApi* | [**update**](docs/ImportersPulpApi.md#update) | **PUT** {pulp_importer_href} | Update a pulp importer
*ImportersPulpImportCheckApi* | [**pulp_import_check_post**](docs/ImportersPulpImportCheckApi.md#pulp_import_check_post) | **POST** /pulp/api/v3/importers/core/pulp/import-check/ | Validate the parameters to be used for a PulpImport call
*ImportersPulpImportsApi* | [**create**](docs/ImportersPulpImportsApi.md#create) | **POST** {pulp_importer_href}imports/ | Create a pulp import
*ImportersPulpImportsApi* | [**delete**](docs/ImportersPulpImportsApi.md#delete) | **DELETE** {pulp_pulp_import_href} | Delete a pulp import
*ImportersPulpImportsApi* | [**list**](docs/ImportersPulpImportsApi.md#list) | **GET** {pulp_importer_href}imports/ | List pulp imports
*ImportersPulpImportsApi* | [**read**](docs/ImportersPulpImportsApi.md#read) | **GET** {pulp_pulp_import_href} | Inspect a pulp import
*OrphansApi* | [**delete**](docs/OrphansApi.md#delete) | **DELETE** /pulp/api/v3/orphans/ | Delete orphans
*OrphansCleanupApi* | [**cleanup**](docs/OrphansCleanupApi.md#cleanup) | **POST** /pulp/api/v3/orphans/cleanup/ | 
*PublicationsApi* | [**list**](docs/PublicationsApi.md#list) | **GET** /pulp/api/v3/publications/ | List publications
*RepairApi* | [**post**](docs/RepairApi.md#post) | **POST** /pulp/api/v3/repair/ | Repair Artifact Storage
*RepositoriesApi* | [**list**](docs/RepositoriesApi.md#list) | **GET** /pulp/api/v3/repositories/ | List repositories
*RepositoryVersionsApi* | [**list**](docs/RepositoryVersionsApi.md#list) | **GET** /pulp/api/v3/repository_versions/ | List repository versions
*SigningServicesApi* | [**list**](docs/SigningServicesApi.md#list) | **GET** /pulp/api/v3/signing-services/ | List signing services
*SigningServicesApi* | [**read**](docs/SigningServicesApi.md#read) | **GET** {signing_service_href} | Inspect a signing service
*StatusApi* | [**status_read**](docs/StatusApi.md#status_read) | **GET** /pulp/api/v3/status/ | Inspect status of Pulp
*TaskGroupsApi* | [**list**](docs/TaskGroupsApi.md#list) | **GET** /pulp/api/v3/task-groups/ | List task groups
*TaskGroupsApi* | [**read**](docs/TaskGroupsApi.md#read) | **GET** {task_group_href} | Inspect a task group
*TasksApi* | [**delete**](docs/TasksApi.md#delete) | **DELETE** {task_href} | Delete a task
*TasksApi* | [**list**](docs/TasksApi.md#list) | **GET** /pulp/api/v3/tasks/ | List tasks
*TasksApi* | [**read**](docs/TasksApi.md#read) | **GET** {task_href} | Inspect a task
*TasksApi* | [**tasks_cancel**](docs/TasksApi.md#tasks_cancel) | **PATCH** {task_href} | Cancel a task
*UploadsApi* | [**commit**](docs/UploadsApi.md#commit) | **POST** {upload_href}commit/ | Finish an Upload
*UploadsApi* | [**create**](docs/UploadsApi.md#create) | **POST** /pulp/api/v3/uploads/ | Create an upload
*UploadsApi* | [**delete**](docs/UploadsApi.md#delete) | **DELETE** {upload_href} | Delete an upload
*UploadsApi* | [**list**](docs/UploadsApi.md#list) | **GET** /pulp/api/v3/uploads/ | List uploads
*UploadsApi* | [**read**](docs/UploadsApi.md#read) | **GET** {upload_href} | Inspect an upload
*UploadsApi* | [**update**](docs/UploadsApi.md#update) | **PUT** {upload_href} | Upload a file chunk
*UsersApi* | [**list**](docs/UsersApi.md#list) | **GET** /pulp/api/v3/users/ | List users
*UsersApi* | [**permissions**](docs/UsersApi.md#permissions) | **GET** {auth_user_href}permissions/ | 
*UsersApi* | [**read**](docs/UsersApi.md#read) | **GET** {auth_user_href} | Inspect an user
*WorkersApi* | [**list**](docs/WorkersApi.md#list) | **GET** /pulp/api/v3/workers/ | List workers
*WorkersApi* | [**read**](docs/WorkersApi.md#read) | **GET** {worker_href} | Inspect a worker


## Documentation For Models

 - [AccessPolicy](docs/AccessPolicy.md)
 - [AccessPolicyResponse](docs/AccessPolicyResponse.md)
 - [Artifact](docs/Artifact.md)
 - [ArtifactResponse](docs/ArtifactResponse.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentAppStatusResponse](docs/ContentAppStatusResponse.md)
 - [ContentGuardResponse](docs/ContentGuardResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [DatabaseConnectionResponse](docs/DatabaseConnectionResponse.md)
 - [EvaluationResponse](docs/EvaluationResponse.md)
 - [Group](docs/Group.md)
 - [GroupProgressReportResponse](docs/GroupProgressReportResponse.md)
 - [GroupResponse](docs/GroupResponse.md)
 - [GroupUser](docs/GroupUser.md)
 - [GroupUserResponse](docs/GroupUserResponse.md)
 - [ImportResponse](docs/ImportResponse.md)
 - [MinimalTaskResponse](docs/MinimalTaskResponse.md)
 - [MultipleArtifactContentResponse](docs/MultipleArtifactContentResponse.md)
 - [OrphansCleanup](docs/OrphansCleanup.md)
 - [PaginatedAccessPolicyResponseList](docs/PaginatedAccessPolicyResponseList.md)
 - [PaginatedArtifactResponseList](docs/PaginatedArtifactResponseList.md)
 - [PaginatedContentGuardResponseList](docs/PaginatedContentGuardResponseList.md)
 - [PaginatedGroupResponseList](docs/PaginatedGroupResponseList.md)
 - [PaginatedGroupUserResponseList](docs/PaginatedGroupUserResponseList.md)
 - [PaginatedImportResponseList](docs/PaginatedImportResponseList.md)
 - [PaginatedMultipleArtifactContentResponseList](docs/PaginatedMultipleArtifactContentResponseList.md)
 - [PaginatedPermissionResponseList](docs/PaginatedPermissionResponseList.md)
 - [PaginatedPublicationResponseList](docs/PaginatedPublicationResponseList.md)
 - [PaginatedPulpExportResponseList](docs/PaginatedPulpExportResponseList.md)
 - [PaginatedPulpExporterResponseList](docs/PaginatedPulpExporterResponseList.md)
 - [PaginatedPulpImporterResponseList](docs/PaginatedPulpImporterResponseList.md)
 - [PaginatedRepositoryResponseList](docs/PaginatedRepositoryResponseList.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedSigningServiceResponseList](docs/PaginatedSigningServiceResponseList.md)
 - [PaginatedTaskGroupResponseList](docs/PaginatedTaskGroupResponseList.md)
 - [PaginatedTaskResponseList](docs/PaginatedTaskResponseList.md)
 - [PaginatedUploadResponseList](docs/PaginatedUploadResponseList.md)
 - [PaginatedUserResponseList](docs/PaginatedUserResponseList.md)
 - [PaginatedWorkerResponseList](docs/PaginatedWorkerResponseList.md)
 - [PatchedAccessPolicy](docs/PatchedAccessPolicy.md)
 - [PatchedGroup](docs/PatchedGroup.md)
 - [PatchedPulpExporter](docs/PatchedPulpExporter.md)
 - [PatchedPulpImporter](docs/PatchedPulpImporter.md)
 - [PatchedTaskCancel](docs/PatchedTaskCancel.md)
 - [PermissionResponse](docs/PermissionResponse.md)
 - [ProgressReportResponse](docs/ProgressReportResponse.md)
 - [PublicationResponse](docs/PublicationResponse.md)
 - [PulpExport](docs/PulpExport.md)
 - [PulpExportResponse](docs/PulpExportResponse.md)
 - [PulpExporter](docs/PulpExporter.md)
 - [PulpExporterResponse](docs/PulpExporterResponse.md)
 - [PulpImport](docs/PulpImport.md)
 - [PulpImportCheck](docs/PulpImportCheck.md)
 - [PulpImportCheckResponse](docs/PulpImportCheckResponse.md)
 - [PulpImporter](docs/PulpImporter.md)
 - [PulpImporterResponse](docs/PulpImporterResponse.md)
 - [RedisConnectionResponse](docs/RedisConnectionResponse.md)
 - [Repair](docs/Repair.md)
 - [RepositoryResponse](docs/RepositoryResponse.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [SigningServiceResponse](docs/SigningServiceResponse.md)
 - [StatusResponse](docs/StatusResponse.md)
 - [StorageResponse](docs/StorageResponse.md)
 - [TaskGroupResponse](docs/TaskGroupResponse.md)
 - [TaskResponse](docs/TaskResponse.md)
 - [Upload](docs/Upload.md)
 - [UploadChunk](docs/UploadChunk.md)
 - [UploadChunkResponse](docs/UploadChunkResponse.md)
 - [UploadCommit](docs/UploadCommit.md)
 - [UploadDetailResponse](docs/UploadDetailResponse.md)
 - [UploadResponse](docs/UploadResponse.md)
 - [UserGroupResponse](docs/UserGroupResponse.md)
 - [UserResponse](docs/UserResponse.md)
 - [VersionResponse](docs/VersionResponse.md)
 - [WorkerResponse](docs/WorkerResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: Session
- **Location**: 


## Author

pulp-list@redhat.com


