from __future__ import annotations

import io
import zipfile
from typing import Union


class InMemoryZip(object):
    def __init__(self):
        # Create the in-memory file-like object
        self.in_memory_zip = io.BytesIO()

    def append(self, filename_in_zip: str, file_contents: Union[str, bytes]) -> InMemoryZip:
        """
        Appends a file with name filename_in_zip and contents of
        file_contents to the in-memory zip.
        """

        # Get a handle to the in-memory zip in append mode
        zf = zipfile.ZipFile(self.in_memory_zip, "a", zipfile.ZIP_DEFLATED, False)

        # Write the file to the in-memory zip
        zf.writestr(filename_in_zip, file_contents)

        # Mark the files as having been created on Windows so that
        # Unix permissions are not inferred as 0000
        for zfile in zf.filelist:
            zfile.create_system = 0

        return self

    def read(self) -> bytes:
        """
        Returns a string with the contents of the in-memory zip.
        """

        self.in_memory_zip.seek(0)
        return self.in_memory_zip.read()
