"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const render_options_1 = require("../javascript/render-options");
const projenrc_1 = require("../projenrc");
/**
 * Sets up a typescript project to use TypeScript for projenrc.
 */
class Projenrc extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this._tsProject = project;
        this.filePath = options.filename ?? ".projenrc.ts";
        this._projenCodeDir = options.projenCodeDir ?? "projenrc";
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        project.addDevDeps("ts-node");
        // we use "tsconfig.dev.json" here to allow projen source files to reside
        // anywhere in the project tree.
        project.defaultTask?.exec(`ts-node --project ${project.tsconfigDev.fileName} ${this.filePath}`);
        this.generateProjenrc();
    }
    preSynthesize() {
        this._tsProject.tsconfigDev.addInclude(this.filePath);
        this._tsProject.tsconfigDev.addInclude(`${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addLintPattern(this._projenCodeDir);
        this._tsProject.eslint?.addLintPattern(this.filePath);
        this._tsProject.eslint?.allowDevDeps(this.filePath);
        this._tsProject.eslint?.allowDevDeps(`${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addIgnorePattern(`!${this.filePath}`);
        this._tsProject.eslint?.addIgnorePattern(`!${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addOverride({
            files: [this.filePath],
            rules: {
                "@typescript-eslint/no-require-imports": "off",
                "import/no-extraneous-dependencies": "off",
            },
        });
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.filePath);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asEsmImports());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        fs_1.mkdirSync(path_1.dirname(rcfile), { recursive: true });
        fs_1.writeFileSync(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.69.3" };
//# sourceMappingURL=data:application/json;base64,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